/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.catalog;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.function.cloudevent.CloudEventMessageUtils;
import org.springframework.cloud.function.context.FunctionProperties;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.FunctionRegistry;
import org.springframework.cloud.function.context.catalog.FunctionAroundWrapper;
import org.springframework.cloud.function.context.catalog.FunctionInspector;
import org.springframework.cloud.function.context.catalog.FunctionTypeUtils;
import org.springframework.cloud.function.context.catalog.HeaderEnricher;
import org.springframework.cloud.function.context.config.RoutingFunction;
import org.springframework.cloud.function.core.FunctionInvocationHelper;
import org.springframework.cloud.function.json.JsonMapper;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionService;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuples;

public class SimpleFunctionRegistry
implements FunctionRegistry,
FunctionInspector {
    protected Log logger = LogFactory.getLog(this.getClass());
    private final Set<FunctionRegistration<?>> functionRegistrations = new CopyOnWriteArraySet();
    private final Map<String, FunctionInvocationWrapper> wrappedFunctionDefinitions = new HashMap<String, FunctionInvocationWrapper>();
    private final ConversionService conversionService;
    private final CompositeMessageConverter messageConverter;
    private final JsonMapper jsonMapper;
    private final FunctionInvocationHelper<Message<?>> functionInvocationHelper;
    private final FunctionProperties functionProperties;
    @Autowired(required=false)
    private FunctionAroundWrapper functionAroundWrapper;

    public SimpleFunctionRegistry(ConversionService conversionService, CompositeMessageConverter messageConverter, JsonMapper jsonMapper, @Nullable FunctionProperties functionProperties, @Nullable FunctionInvocationHelper<Message<?>> functionInvocationHelper) {
        Assert.notNull((Object)messageConverter, (String)"'messageConverter' must not be null");
        Assert.notNull((Object)jsonMapper, (String)"'jsonMapper' must not be null");
        this.conversionService = conversionService;
        this.jsonMapper = jsonMapper;
        this.messageConverter = messageConverter;
        this.functionInvocationHelper = functionInvocationHelper;
        this.functionProperties = functionProperties;
    }

    public void addMessageConverters(Collection<MessageConverter> messageConverters) {
        if (!CollectionUtils.isEmpty(messageConverters)) {
            this.messageConverter.getConverters().addAll(0, messageConverters);
        }
    }

    @Override
    public FunctionRegistration<?> getRegistration(Object function) {
        throw new UnsupportedOperationException("FunctionInspector is deprecated. There is no need to access FunctionRegistration directly since you can interogate the actual looked-up function (see FunctionInvocationWrapper.");
    }

    public SimpleFunctionRegistry(ConversionService conversionService, CompositeMessageConverter messageConverter, JsonMapper jsonMapper) {
        this(conversionService, messageConverter, jsonMapper, null, null);
    }

    @Override
    public <T> T lookup(Class<?> type, String functionDefinition, String ... expectedOutputMimeTypes) {
        functionDefinition = this.normalizeFunctionDefinition(functionDefinition);
        FunctionInvocationWrapper function = (FunctionInvocationWrapper)this.doLookup(type, functionDefinition, expectedOutputMimeTypes);
        if (this.logger.isDebugEnabled()) {
            if (function != null) {
                this.logger.debug((Object)("Located function: " + function));
            } else {
                this.logger.debug((Object)("Failed to locate function: " + functionDefinition));
            }
        }
        return (T)function;
    }

    @Override
    public <T> void register(FunctionRegistration<T> registration) {
        if (!this.isRegistrationEligible(registration)) {
            return;
        }
        Assert.notNull(registration, (String)"'registration' must not be null");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Registering function " + registration.getNames()));
        }
        this.functionRegistrations.add(registration);
    }

    private boolean isRegistrationEligible(FunctionRegistration registration) {
        if (this.functionProperties != null) {
            for (String definition : this.functionProperties.getIneligibleDefinitions()) {
                if (registration.getTarget().getClass().getName().equals(definition)) {
                    return false;
                }
                if (!registration.getNames().contains(definition) && !registration.getTarget().getClass().getName().contains(definition)) continue;
                return false;
            }
        }
        return true;
    }

    boolean isFunctionDefinitionEligible(String functionDefinition) {
        if (this.functionProperties != null) {
            for (String definition : this.functionProperties.getIneligibleDefinitions()) {
                if (!functionDefinition.contains(definition)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Set<String> getNames(Class<?> type) {
        return this.functionRegistrations.stream().flatMap(fr -> fr.getNames().stream()).collect(Collectors.toSet());
    }

    @Override
    public int size() {
        return this.functionRegistrations.size();
    }

    protected boolean containsFunction(String functionName) {
        return this.functionRegistrations.stream().anyMatch(reg -> reg.getNames().contains(functionName));
    }

    <T> T doLookup(Class<?> type, String functionDefinition, String[] expectedOutputMimeTypes) {
        FunctionInvocationWrapper function = this.wrappedFunctionDefinitions.get(functionDefinition);
        if (function == null) {
            function = this.compose(type, functionDefinition);
        }
        if (function != null) {
            if (!ObjectUtils.isEmpty((Object[])expectedOutputMimeTypes)) {
                FunctionInvocationWrapper.access$002(function, expectedOutputMimeTypes);
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Function '" + functionDefinition + "' is not found in cache"));
        }
        if (function != null) {
            function = this.wrapInAroundAdviceIfNecessary(function);
        }
        return (T)function;
    }

    String normalizeFunctionDefinition(String functionDefinition) {
        List eligibleFunction;
        functionDefinition = StringUtils.hasText((String)functionDefinition) ? functionDefinition.replaceAll(",", "|") : System.getProperty("spring.cloud.function.definition", "");
        Set<String> names = this.getNames(null);
        if (!(names.contains(functionDefinition) || (eligibleFunction = names.stream().filter(name -> !"functionRouter".equals(name)).collect(Collectors.toList())).size() != 1 || ((String)eligibleFunction.get(0)).equals(functionDefinition) || functionDefinition.contains("|") || ((String)eligibleFunction.get(0)).startsWith("&"))) {
            functionDefinition = (String)eligibleFunction.get(0);
        }
        return functionDefinition;
    }

    private FunctionInvocationWrapper wrapInAroundAdviceIfNecessary(final FunctionInvocationWrapper function) {
        FunctionInvocationWrapper wrappedFunction = function;
        if (!(function == null || this.functionAroundWrapper == null || function.isSupplier() || function.isInputTypePublisher() || function.isOutputTypePublisher() || FunctionTypeUtils.isCollectionOfMessage(function.getOutputType()))) {
            wrappedFunction = new FunctionInvocationWrapper(function){

                @Override
                Object doApply(Object input) {
                    if (SimpleFunctionRegistry.this.logger.isDebugEnabled()) {
                        SimpleFunctionRegistry.this.logger.debug((Object)("Executing around advise(s): " + SimpleFunctionRegistry.this.functionAroundWrapper));
                    }
                    return SimpleFunctionRegistry.this.functionAroundWrapper.apply(input, function);
                }
            };
        }
        return wrappedFunction;
    }

    private FunctionInvocationWrapper findFunctionInFunctionRegistrations(String functionName) {
        FunctionInvocationWrapper function;
        FunctionRegistration functionRegistration = this.functionRegistrations.stream().filter(fr -> fr.getNames().contains(functionName)).findFirst().orElseGet(() -> null);
        FunctionInvocationWrapper functionInvocationWrapper = function = functionRegistration != null ? this.invocationWrapperInstance(functionName, functionRegistration.getTarget(), functionRegistration.getType().getType()) : null;
        if (functionRegistration != null && functionRegistration.getProperties().containsKey("singleton")) {
            try {
                function.isSingleton = Boolean.parseBoolean(functionRegistration.getProperties().get("singleton"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return function;
    }

    private FunctionInvocationWrapper compose(Class<?> type, String functionDefinition) {
        String[] functionNames = StringUtils.delimitedListToStringArray((String)functionDefinition.replaceAll(",", "|").trim(), (String)"|");
        FunctionInvocationWrapper composedFunction = null;
        for (String functionName : functionNames) {
            FunctionInvocationWrapper function = this.findFunctionInFunctionRegistrations(functionName);
            if (function == null) {
                return null;
            }
            if (composedFunction == null) {
                composedFunction = function;
            } else {
                FunctionInvocationWrapper andThenFunction = this.invocationWrapperInstance(functionName, function.getTarget(), function.inputType, function.outputType);
                composedFunction = (FunctionInvocationWrapper)composedFunction.andThen(andThenFunction);
            }
            composedFunction = this.enrichInputIfNecessary(composedFunction);
            composedFunction = this.enrichOutputIfNecessary(composedFunction);
            if (!composedFunction.isSingleton) continue;
            this.wrappedFunctionDefinitions.put(composedFunction.functionDefinition, composedFunction);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Composed function " + composedFunction));
        }
        return composedFunction;
    }

    private FunctionInvocationWrapper enrichInputIfNecessary(FunctionInvocationWrapper composedFunction) {
        FunctionProperties.FunctionConfigurationProperties configuration;
        if (this.functionProperties == null) {
            return composedFunction;
        }
        String functionDefinition = composedFunction.getFunctionDefinition();
        Map<String, FunctionProperties.FunctionConfigurationProperties> configurationProperties = this.functionProperties.getConfiguration();
        if (!CollectionUtils.isEmpty(configurationProperties) && (configuration = configurationProperties.get(functionDefinition.replace("|", "").replace(",", ""))) != null && !CollectionUtils.isEmpty(configuration.getInputHeaderMappingExpression())) {
            BeanFactoryResolver beanResolver = this.functionProperties.getApplicationContext() != null ? new BeanFactoryResolver((BeanFactory)this.functionProperties.getApplicationContext()) : null;
            HeaderEnricher enricher = new HeaderEnricher(configuration.getInputHeaderMappingExpression(), (BeanResolver)beanResolver);
            FunctionInvocationWrapper w = new FunctionInvocationWrapper("inputHeaderEnricher", enricher, (Type)((Object)Message.class), (Type)((Object)Message.class));
            composedFunction = (FunctionInvocationWrapper)w.andThen(composedFunction);
            composedFunction.functionDefinition = functionDefinition;
        }
        return composedFunction;
    }

    private FunctionInvocationWrapper enrichOutputIfNecessary(FunctionInvocationWrapper composedFunction) {
        FunctionProperties.FunctionConfigurationProperties configuration;
        if (this.functionProperties == null) {
            return composedFunction;
        }
        String functionDefinition = composedFunction.getFunctionDefinition();
        Map<String, FunctionProperties.FunctionConfigurationProperties> configurationProperties = this.functionProperties.getConfiguration();
        if (!CollectionUtils.isEmpty(configurationProperties) && (configuration = configurationProperties.get(functionDefinition.replace("|", "").replace(",", ""))) != null && !CollectionUtils.isEmpty(configuration.getOutputHeaderMappingExpression())) {
            BeanFactoryResolver beanResolver = this.functionProperties.getApplicationContext() != null ? new BeanFactoryResolver((BeanFactory)this.functionProperties.getApplicationContext()) : null;
            HeaderEnricher enricher = new HeaderEnricher(configuration.getOutputHeaderMappingExpression(), (BeanResolver)beanResolver);
            Type mesageType = ResolvableType.forClassWithGenerics(Message.class, (Class[])new Class[]{Object.class}).getType();
            FunctionInvocationWrapper enricherWrapper = new FunctionInvocationWrapper("outputHeaderEnricher", enricher, mesageType, mesageType);
            composedFunction = (FunctionInvocationWrapper)composedFunction.andThen(enricherWrapper);
            composedFunction.functionDefinition = functionDefinition;
        }
        return composedFunction;
    }

    private FunctionInvocationWrapper invocationWrapperInstance(String functionDefinition, Object target, Type inputType, Type outputType) {
        return new FunctionInvocationWrapper(functionDefinition, target, inputType, outputType);
    }

    private FunctionInvocationWrapper invocationWrapperInstance(String functionDefinition, Object target, Type functionType) {
        return this.invocationWrapperInstance(functionDefinition, target, FunctionTypeUtils.isSupplier(functionType) ? null : FunctionTypeUtils.getInputType(functionType), FunctionTypeUtils.getOutputType(functionType));
    }

    public static class PassThruFunction
    implements Function<Object, Object> {
        @Override
        public Object apply(Object t) {
            return t;
        }
    }

    private static final class OriginalMessageHolder {
        private final Object value;
        private final Message<?> originalMessage;

        private OriginalMessageHolder(Object value, Message<?> originalMessage) {
            this.value = value;
            this.originalMessage = originalMessage;
        }

        public Object getValue() {
            return this.value;
        }

        public Message<?> getOriginalMessage() {
            return this.originalMessage;
        }
    }

    public class FunctionInvocationWrapper
    implements Function<Object, Object>,
    Consumer<Object>,
    Supplier<Object>,
    Runnable {
        private final Object target;
        private Type inputType;
        private final Type outputType;
        private String functionDefinition;
        private boolean composed;
        private boolean message;
        private String[] expectedOutputContentType;
        private boolean skipInputConversion;
        private boolean skipOutputConversion;
        private boolean isSingleton = true;
        private boolean propagateInputHeaders;
        private Function<Object, Object> enhancer;

        FunctionInvocationWrapper(FunctionInvocationWrapper function) {
            this.expectedOutputContentType = function.expectedOutputContentType;
            this.skipOutputConversion = function.skipOutputConversion;
            this.skipInputConversion = function.skipInputConversion;
            this.target = function.target;
            this.inputType = function.inputType;
            this.outputType = function.outputType;
            this.functionDefinition = function.functionDefinition;
            this.message = this.inputType != null && FunctionTypeUtils.isMessage(this.inputType);
        }

        FunctionInvocationWrapper(String functionDefinition, Object target, Type inputType, Type outputType) {
            FunctionProperties.FunctionConfigurationProperties configuration;
            Map<String, FunctionProperties.FunctionConfigurationProperties> funcConfiguration;
            this.target = target;
            this.inputType = this.normalizeType(inputType);
            this.outputType = this.normalizeType(outputType);
            this.functionDefinition = functionDefinition;
            boolean bl = this.message = this.inputType != null && FunctionTypeUtils.isMessage(this.inputType);
            if (SimpleFunctionRegistry.this.functionProperties != null && !CollectionUtils.isEmpty(funcConfiguration = SimpleFunctionRegistry.this.functionProperties.getConfiguration()) && (configuration = funcConfiguration.get(functionDefinition)) != null) {
                this.propagateInputHeaders = configuration.isCopyInputHeaders();
            }
        }

        public boolean isSkipOutputConversion() {
            return this.skipOutputConversion;
        }

        public boolean isPrototype() {
            return !this.isSingleton;
        }

        public void setSkipInputConversion(boolean skipInputConversion) {
            if (SimpleFunctionRegistry.this.logger.isDebugEnabled() && skipInputConversion) {
                SimpleFunctionRegistry.this.logger.debug((Object)"'skipInputConversion' was explicitely set to true. No input conversion will be attempted");
            }
            this.skipInputConversion = skipInputConversion;
        }

        public void setSkipOutputConversion(boolean skipOutputConversion) {
            if (SimpleFunctionRegistry.this.logger.isDebugEnabled() && skipOutputConversion) {
                SimpleFunctionRegistry.this.logger.debug((Object)"'skipOutputConversion' was explicitely set to true. No output conversion will be attempted");
            }
            this.skipOutputConversion = skipOutputConversion;
        }

        public Function<Object, Object> getEnhancer() {
            return this.enhancer;
        }

        public void setEnhancer(Function<Object, Object> enhancer) {
            this.enhancer = enhancer;
        }

        public Object getTarget() {
            return this.target;
        }

        public Type getOutputType() {
            return this.outputType;
        }

        public Type getInputType() {
            return this.inputType;
        }

        public Type getItemType(Type type) {
            if (FunctionTypeUtils.isPublisher(type) || FunctionTypeUtils.isMessage(type) || FunctionTypeUtils.isTypeCollection(type)) {
                type = FunctionTypeUtils.getGenericType(type);
            }
            if (FunctionTypeUtils.isMessage(type)) {
                type = FunctionTypeUtils.getGenericType(type);
            }
            return type;
        }

        @Deprecated
        public Type getFunctionType() {
            if (this.isFunction()) {
                ResolvableType rItype = ResolvableType.forType((Type)this.inputType);
                ResolvableType rOtype = ResolvableType.forType((Type)this.outputType);
                return ResolvableType.forClassWithGenerics(Function.class, (ResolvableType[])new ResolvableType[]{rItype, rOtype}).getType();
            }
            if (this.isConsumer()) {
                ResolvableType rItype = ResolvableType.forType((Type)this.inputType);
                return ResolvableType.forClassWithGenerics(Consumer.class, (ResolvableType[])new ResolvableType[]{rItype}).getType();
            }
            ResolvableType rOtype = ResolvableType.forType((Type)this.outputType);
            return ResolvableType.forClassWithGenerics(Supplier.class, (ResolvableType[])new ResolvableType[]{rOtype}).getType();
        }

        public Class<?> getRawOutputType() {
            return this.outputType == null ? null : FunctionTypeUtils.getRawType(this.outputType);
        }

        public Class<?> getRawInputType() {
            return this.inputType == null ? null : FunctionTypeUtils.getRawType(this.inputType);
        }

        @Override
        public Object apply(Object input) {
            Object result;
            if (SimpleFunctionRegistry.this.logger.isDebugEnabled() && !(input instanceof Publisher)) {
                SimpleFunctionRegistry.this.logger.debug((Object)("Invoking function " + this));
            }
            Object object = result = this.getTarget() instanceof PassThruFunction ? input : this.doApply(input);
            if (result != null && this.outputType != null) {
                result = this.convertOutputIfNecessary(result, this.outputType, this.expectedOutputContentType);
            }
            return result;
        }

        @Override
        public Object get() {
            return this.apply((Object)null);
        }

        @Override
        public void accept(Object input) {
            this.apply(input);
        }

        @Override
        public void run() {
            this.apply((Object)null);
        }

        public boolean isConsumer() {
            return this.outputType == null;
        }

        public boolean isSupplier() {
            return this.inputType == null;
        }

        public boolean isFunction() {
            return this.inputType != null && this.outputType != null;
        }

        public boolean isInputTypePublisher() {
            return this.isTypePublisher(this.inputType);
        }

        public boolean isOutputTypePublisher() {
            return this.isTypePublisher(this.outputType);
        }

        public boolean isInputTypeMessage() {
            boolean b = this.message || this.isRoutingFunction();
            return b;
        }

        public boolean isOutputTypeMessage() {
            return FunctionTypeUtils.isMessage(this.outputType);
        }

        public boolean isRoutingFunction() {
            return this.target instanceof RoutingFunction;
        }

        @Override
        public <V> Function<Object, V> andThen(Function<? super Object, ? extends V> after) {
            Type composedFunctionType;
            Assert.isTrue((boolean)(after instanceof FunctionInvocationWrapper), (String)"Composed function must be an instanceof FunctionInvocationWrapper.");
            if (FunctionTypeUtils.isMultipleArgumentType(this.inputType) || FunctionTypeUtils.isMultipleArgumentType(this.outputType) || FunctionTypeUtils.isMultipleArgumentType(((FunctionInvocationWrapper)after).inputType) || FunctionTypeUtils.isMultipleArgumentType(((FunctionInvocationWrapper)after).outputType)) {
                throw new UnsupportedOperationException("Composition of functions with multiple arguments is not supported at the moment");
            }
            Function<Object, Object> rawComposedFunction = v -> ((FunctionInvocationWrapper)after).doApply(this.doApply(v));
            FunctionInvocationWrapper afterWrapper = (FunctionInvocationWrapper)after;
            if (afterWrapper.outputType == null) {
                composedFunctionType = this.inputType == null ? ResolvableType.forClassWithGenerics(Supplier.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType(Object.class)}).getType() : ResolvableType.forClassWithGenerics(Consumer.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType((Type)this.inputType)}).getType();
            } else if (this.inputType == null && afterWrapper.outputType != null) {
                ResolvableType composedOutputType = FunctionTypeUtils.isFlux(this.outputType) ? ResolvableType.forClassWithGenerics(Flux.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType((Type)afterWrapper.outputType)}) : (FunctionTypeUtils.isMono(this.outputType) ? ResolvableType.forClassWithGenerics(Mono.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType((Type)afterWrapper.outputType)}) : ResolvableType.forType((Type)afterWrapper.outputType));
                composedFunctionType = ResolvableType.forClassWithGenerics(Supplier.class, (ResolvableType[])new ResolvableType[]{composedOutputType}).getType();
            } else {
                if (this.outputType == null) {
                    throw new IllegalArgumentException("Can NOT compose anything with Consumer");
                }
                composedFunctionType = ResolvableType.forClassWithGenerics(Function.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType((Type)this.inputType), ResolvableType.forType((Type)((FunctionInvocationWrapper)after).outputType)}).getType();
            }
            String composedName = this.functionDefinition + "|" + afterWrapper.functionDefinition;
            FunctionInvocationWrapper composedFunction = SimpleFunctionRegistry.this.invocationWrapperInstance(composedName, rawComposedFunction, composedFunctionType);
            composedFunction.composed = true;
            return composedFunction;
        }

        public String getFunctionDefinition() {
            return this.functionDefinition;
        }

        public String toString() {
            return this.functionDefinition + (this.isComposed() ? "" : "<" + this.inputType + ", " + this.outputType + ">");
        }

        boolean isComposed() {
            return this.composed;
        }

        Object doApply(Object input) {
            input = this.fluxifyInputIfNecessary(input);
            Object convertedInput = this.convertInputIfNecessary(input, this.inputType);
            Object result = this.isRoutingFunction() || this.isComposed() ? ((Function)this.target).apply(convertedInput) : (this.isSupplier() ? ((Supplier)this.target).get() : (this.isConsumer() ? this.invokeConsumer(convertedInput) : this.invokeFunction(convertedInput)));
            return result;
        }

        private boolean isTypePublisher(Type type) {
            return type != null && FunctionTypeUtils.isPublisher(type);
        }

        private Type normalizeType(Type type) {
            if (type != null) {
                return !(type instanceof TypeVariable) && !(type instanceof WildcardType) ? type : Object.class;
            }
            return type;
        }

        private Class<?> getRawClassFor(@Nullable Type type) {
            return type instanceof TypeVariable || type instanceof WildcardType ? Object.class : FunctionTypeUtils.getRawType(type);
        }

        private Object enrichInvocationResultIfNecessary(Object input, Object result) {
            if (result != null && !(result instanceof Publisher) && input instanceof Message) {
                if (result instanceof Message) {
                    if (SimpleFunctionRegistry.this.functionInvocationHelper != null && CloudEventMessageUtils.isCloudEvent((Message)input)) {
                        result = SimpleFunctionRegistry.this.functionInvocationHelper.postProcessResult(result, (Object)((Message)input));
                    }
                } else if (SimpleFunctionRegistry.this.functionInvocationHelper != null && CloudEventMessageUtils.isCloudEvent((Message)input)) {
                    result = SimpleFunctionRegistry.this.functionInvocationHelper.postProcessResult(result, (Object)((Message)input));
                } else if (!FunctionTypeUtils.isCollectionOfMessage(this.outputType)) {
                    result = MessageBuilder.withPayload((Object)result).copyHeaders(this.sanitizeHeaders(((Message)input).getHeaders())).build();
                }
            }
            return result;
        }

        private Map<String, Object> sanitizeHeaders(MessageHeaders headers) {
            HashMap<String, Object> sanitizedHeaders = new HashMap<String, Object>();
            headers.forEach((k, v) -> {
                if (v != null) {
                    sanitizedHeaders.put((String)k, v);
                }
            });
            return sanitizedHeaders;
        }

        private Object fluxifyInputIfNecessary(Object input) {
            if (FunctionTypeUtils.isMultipleArgumentType(this.inputType)) {
                return input;
            }
            if (!this.isRoutingFunction() && !(input instanceof Publisher)) {
                List payload = input;
                if (input instanceof Message) {
                    payload = ((Message)input).getPayload();
                }
                if (JsonMapper.isJsonStringRepresentsCollection(payload) && !FunctionTypeUtils.isTypeCollection(this.inputType) && !FunctionTypeUtils.isTypeArray(this.inputType)) {
                    MessageHeaders headers = ((Message)input).getHeaders();
                    Collection collectionPayload = (Collection)SimpleFunctionRegistry.this.jsonMapper.fromJson(payload, (Type)((Object)Collection.class));
                    Class<Object> inputClass = FunctionTypeUtils.getRawType(this.inputType);
                    if (this.isInputTypeMessage()) {
                        inputClass = FunctionTypeUtils.getRawType(FunctionTypeUtils.getImmediateGenericType(this.inputType, 0));
                    }
                    if (!inputClass.isAssignableFrom(Object.class) && !inputClass.isAssignableFrom(byte[].class)) {
                        SimpleFunctionRegistry.this.logger.debug((Object)("Converting JSON string representing collection to a list of Messages. Function '" + this + "' will be invoked iteratively"));
                        input = collectionPayload.stream().map(p -> MessageBuilder.withPayload((Object)p).copyHeaders((Map)headers).build()).collect(Collectors.toList());
                    }
                }
            }
            if (this.isTypePublisher(this.inputType) && !(input instanceof Publisher)) {
                input = input == null ? (FunctionTypeUtils.isMono(this.inputType) ? Mono.empty() : Flux.empty()) : (input instanceof Message && ((Message)input).getPayload() instanceof Iterable ? (FunctionTypeUtils.isMono(this.inputType) ? Mono.just((Object)input) : Flux.just((Object)input).flatMap(v -> {
                    if (SimpleFunctionRegistry.this.logger.isDebugEnabled()) {
                        SimpleFunctionRegistry.this.logger.debug((Object)("Creating Flux from Iterable: " + ((Message)v).getPayload()));
                    }
                    return Flux.fromIterable((Iterable)((Iterable)((Message)v).getPayload()));
                })) : (input instanceof Iterable ? (FunctionTypeUtils.isMono(this.inputType) ? Mono.just((Object)input) : Flux.fromIterable((Iterable)input)) : (FunctionTypeUtils.isMono(this.inputType) ? Mono.just((Object)input) : Flux.just((Object)input))));
            } else if (!(input instanceof Publisher) && input instanceof Iterable && !FunctionTypeUtils.isTypeCollection(this.inputType)) {
                input = Flux.fromIterable((Iterable)input);
            }
            return input;
        }

        private Object invokeFunction(Object convertedInput) {
            Object result;
            if (!this.isTypePublisher(this.inputType) && convertedInput instanceof Publisher) {
                result = convertedInput instanceof Mono ? Mono.from((Publisher)((Publisher)convertedInput)).map(value -> this.invokeFunctionAndEnrichResultIfNecessary(value)).doOnError(ex -> SimpleFunctionRegistry.this.logger.error((Object)("Failed to invoke function '" + this.functionDefinition + "'"), (Throwable)ex)) : Flux.from((Publisher)((Publisher)convertedInput)).map(value -> this.invokeFunctionAndEnrichResultIfNecessary(value)).doOnError(ex -> SimpleFunctionRegistry.this.logger.error((Object)("Failed to invoke function '" + this.functionDefinition + "'"), (Throwable)ex));
            } else {
                result = this.invokeFunctionAndEnrichResultIfNecessary(convertedInput);
                if (result instanceof Flux) {
                    result = ((Flux)result).doOnError(ex -> SimpleFunctionRegistry.this.logger.error((Object)("Failed to invoke function '" + this.functionDefinition + "'"), (Throwable)ex));
                } else if (result instanceof Mono) {
                    result = ((Mono)result).doOnError(ex -> SimpleFunctionRegistry.this.logger.error((Object)("Failed to invoke function '" + this.functionDefinition + "'"), (Throwable)ex));
                }
            }
            return result;
        }

        private Object invokeFunctionAndEnrichResultIfNecessary(Object value) {
            Object result;
            AtomicReference firstInputMessage = new AtomicReference();
            Object inputValue = value instanceof Flux ? ((Flux)value).map(v -> {
                if (v instanceof OriginalMessageHolder && firstInputMessage.get() == null) {
                    firstInputMessage.set(((OriginalMessageHolder)v).getOriginalMessage());
                }
                return this.extractValueFromOriginalValueHolderIfNecessary(v);
            }) : (value instanceof Mono ? ((Mono)value).map(v -> {
                if (v instanceof OriginalMessageHolder) {
                    firstInputMessage.set(((OriginalMessageHolder)v).getOriginalMessage());
                }
                return this.extractValueFromOriginalValueHolderIfNecessary(v);
            }) : this.extractValueFromOriginalValueHolderIfNecessary(value));
            if (inputValue instanceof Message && !this.isInputTypeMessage()) {
                inputValue = ((Message)inputValue).getPayload();
            }
            if ((result = ((Function)this.target).apply(inputValue)) instanceof Publisher && SimpleFunctionRegistry.this.functionInvocationHelper != null) {
                result = this.postProcessFunction((Publisher)result, firstInputMessage);
            }
            return value instanceof OriginalMessageHolder ? this.enrichInvocationResultIfNecessary(((OriginalMessageHolder)value).getOriginalMessage(), result) : result;
        }

        private Publisher postProcessFunction(Publisher result, AtomicReference<Message<?>> firstInputMessage) {
            if (FunctionTypeUtils.isPublisher(this.inputType) && FunctionTypeUtils.isPublisher(this.outputType) && !FunctionTypeUtils.getRawType(FunctionTypeUtils.getImmediateGenericType(this.inputType, 0)).isAssignableFrom(Void.class) && !FunctionTypeUtils.getRawType(FunctionTypeUtils.getImmediateGenericType(this.outputType, 0)).isAssignableFrom(Void.class)) {
                if (result instanceof Mono) {
                    return Mono.from((Publisher)result).map(v -> {
                        if (firstInputMessage.get() != null && CloudEventMessageUtils.isCloudEvent((Message)firstInputMessage.get())) {
                            return SimpleFunctionRegistry.this.functionInvocationHelper.postProcessResult(v, firstInputMessage.get());
                        }
                        return v;
                    });
                }
                return Flux.from((Publisher)result).map(v -> {
                    if (firstInputMessage.get() != null && CloudEventMessageUtils.isCloudEvent((Message)firstInputMessage.get())) {
                        return SimpleFunctionRegistry.this.functionInvocationHelper.postProcessResult(v, firstInputMessage.get());
                    }
                    return v;
                });
            }
            return result;
        }

        private Object invokeConsumer(Object convertedInput) {
            Mono result = null;
            if (this.isTypePublisher(this.inputType)) {
                result = convertedInput instanceof Flux ? ((Flux)convertedInput).transform(flux -> {
                    flux = Flux.from((Publisher)((Publisher)flux)).map(v -> this.extractValueFromOriginalValueHolderIfNecessary(v));
                    ((Consumer)this.target).accept(flux);
                    return Mono.ignoreElements((Publisher)((Flux)flux));
                }).then() : ((Mono)convertedInput).transform(mono -> {
                    mono = Mono.from((Publisher)((Publisher)mono)).map(v -> this.extractValueFromOriginalValueHolderIfNecessary(v));
                    ((Consumer)this.target).accept(mono);
                    return Mono.ignoreElements((Publisher)((Mono)mono));
                }).then();
            } else if (convertedInput instanceof Publisher) {
                result = convertedInput instanceof Mono ? Mono.from((Publisher)((Publisher)convertedInput)).map(v -> this.extractValueFromOriginalValueHolderIfNecessary(v)).doOnNext((Consumer)this.target).then() : Flux.from((Publisher)((Publisher)convertedInput)).map(v -> this.extractValueFromOriginalValueHolderIfNecessary(v)).doOnNext((Consumer)this.target).then();
            } else {
                ((Consumer)this.target).accept(this.extractValueFromOriginalValueHolderIfNecessary(convertedInput));
            }
            return result;
        }

        private Object extractValueFromOriginalValueHolderIfNecessary(Object input) {
            if (input instanceof OriginalMessageHolder) {
                input = ((OriginalMessageHolder)input).getValue();
            }
            return input;
        }

        private Object[] parseMultipleValueArguments(Object multipleValueArgument, int argumentCount) {
            Object[] parsedArgumentValues = new Object[argumentCount];
            if (multipleValueArgument.getClass().getName().startsWith("reactor.util.function.Tuple")) {
                for (int i = 0; i < argumentCount; ++i) {
                    Object outputArgument;
                    Expression parsed = new SpelExpressionParser().parseExpression("getT" + (i + 1) + "()");
                    parsedArgumentValues[i] = outputArgument = parsed.getValue(multipleValueArgument);
                }
                return parsedArgumentValues;
            }
            throw new UnsupportedOperationException("At the moment only Tuple-based function are supporting multiple arguments");
        }

        private boolean isInputConversionNecessary(Object input, Type type) {
            if (type == null || this.getRawClassFor(type) == Void.class || this.target instanceof RoutingFunction || this.isComposed()) {
                if (this.getRawClassFor(type) == Void.class) {
                    if (input instanceof Message && (input = ((Message)input).getPayload()) instanceof Optional) {
                        input = ((Optional)input).orElseGet(() -> null);
                    }
                    Assert.isNull((Object)input, (String)"Can't have non-null input with Void input type.");
                }
                return false;
            }
            return true;
        }

        private Object convertInputIfNecessary(Object input, Type type) {
            if (!this.isInputConversionNecessary(input, type)) {
                return input;
            }
            Object convertedInput = null;
            if (input instanceof Publisher) {
                convertedInput = this.convertInputPublisherIfNecessary((Publisher)input, type);
            } else if (FunctionTypeUtils.isMultipleArgumentType(type)) {
                Type[] inputTypes = ((ParameterizedType)type).getActualTypeArguments();
                Object[] multipleValueArguments = this.parseMultipleValueArguments(input, inputTypes.length);
                Object[] convertedInputs = new Object[inputTypes.length];
                for (int i = 0; i < multipleValueArguments.length; ++i) {
                    Object cInput;
                    convertedInputs[i] = cInput = this.convertInputIfNecessary(multipleValueArguments[i], inputTypes[i]);
                }
                convertedInput = Tuples.fromArray((Object[])convertedInputs);
            } else if (this.skipInputConversion) {
                convertedInput = this.isInputTypeMessage() ? input : new OriginalMessageHolder(((Message)input).getPayload(), (Message)input);
            } else if (input instanceof Message) {
                if (((Message)(input = this.filterOutHeaders((Message)input))).getPayload().getClass().getName().equals("org.springframework.kafka.support.KafkaNull")) {
                    return FunctionTypeUtils.isMessage(type) ? input : null;
                }
                if (SimpleFunctionRegistry.this.functionInvocationHelper != null) {
                    input = SimpleFunctionRegistry.this.functionInvocationHelper.preProcessInput((Object)((Message)input), (Object)SimpleFunctionRegistry.this.messageConverter);
                }
                if ((convertedInput = this.convertInputMessageIfNecessary((Message)input, type)) == null) {
                    convertedInput = this.convertNonMessageInputIfNecessary(type, ((Message)input).getPayload(), false);
                }
                if (convertedInput != null && !FunctionTypeUtils.isMultipleArgumentType(this.inputType)) {
                    Object object = convertedInput = !convertedInput.equals(input) ? new OriginalMessageHolder(convertedInput, (Message)input) : convertedInput;
                }
                if (convertedInput != null && SimpleFunctionRegistry.this.logger.isDebugEnabled()) {
                    SimpleFunctionRegistry.this.logger.debug((Object)("Converted Message: " + input + " to: " + convertedInput));
                }
            } else {
                convertedInput = this.convertNonMessageInputIfNecessary(type, input, JsonMapper.isJsonString(input));
                if (convertedInput != null && SimpleFunctionRegistry.this.logger.isDebugEnabled()) {
                    SimpleFunctionRegistry.this.logger.debug((Object)("Converted input: " + input + " to: " + convertedInput));
                }
            }
            if (this.isWrapConvertedInputInMessage(convertedInput)) {
                convertedInput = MessageBuilder.withPayload((Object)convertedInput).build();
            }
            Object finalInput = input;
            Assert.notNull((Object)convertedInput, () -> "Failed to convert input: " + finalInput + " to " + type);
            return convertedInput;
        }

        private Message filterOutHeaders(Message message) {
            return MessageBuilder.fromMessage((Message)message).removeHeader("spring.cloud.stream.sendto.destination").build();
        }

        private boolean isExtractPayload(Message<?> message, Type type) {
            if (this.propagateInputHeaders) {
                return false;
            }
            if (this.isRoutingFunction()) {
                return false;
            }
            if (FunctionTypeUtils.isCollectionOfMessage(type)) {
                return true;
            }
            if (FunctionTypeUtils.isMessage(type)) {
                return false;
            }
            Object payload = message.getPayload();
            if (payload instanceof byte[]) {
                return false;
            }
            if (ObjectUtils.isArray((Object)payload)) {
                payload = CollectionUtils.arrayToList((Object)payload);
            }
            if (payload instanceof Collection && !CollectionUtils.isEmpty((Collection)((Collection)payload)) && Message.class.isAssignableFrom(CollectionUtils.findCommonElementType((Collection)((Collection)payload)))) {
                return true;
            }
            return !this.containsRetainMessageSignalInHeaders(message);
        }

        private Object convertOutputIfNecessary(Object output, Type type, String[] contentType) {
            Object convertedOutput = output;
            if (this.skipOutputConversion) {
                return convertedOutput;
            }
            if (convertedOutput instanceof Publisher) {
                return this.convertOutputPublisherIfNecessary((Publisher)convertedOutput, type, contentType);
            }
            if (convertedOutput instanceof Message) {
                if (((Message)convertedOutput).getPayload() instanceof byte[] && ObjectUtils.isEmpty((Object[])contentType)) {
                    return convertedOutput;
                }
                if (this.isExtractPayload((Message)convertedOutput, type)) {
                    convertedOutput = ((Message)convertedOutput).getPayload();
                }
            }
            if (this.enhancer != null) {
                convertedOutput = this.enhancer.apply(convertedOutput);
            }
            if (this.getTarget() instanceof PassThruFunction) {
                Message enrichedMessage = MessageBuilder.fromMessage((Message)((Message)convertedOutput)).setHeader("contentType", (Object)contentType[0]).build();
                return SimpleFunctionRegistry.this.messageConverter.toMessage(enrichedMessage.getPayload(), enrichedMessage.getHeaders());
            }
            if (ObjectUtils.isEmpty((Object[])contentType)) {
                return convertedOutput;
            }
            convertedOutput = FunctionTypeUtils.isMultipleArgumentType(type) ? this.convertMultipleOutputArgumentTypeIfNecesary(convertedOutput, type, contentType) : (convertedOutput instanceof Message ? this.convertOutputMessageIfNecessary(convertedOutput, ObjectUtils.isEmpty((Object[])contentType) ? null : contentType[0]) : (convertedOutput instanceof Collection && this.isOutputTypeMessage() ? this.convertMultipleOutputValuesIfNecessary(convertedOutput, ObjectUtils.isEmpty((Object[])contentType) ? null : contentType) : (ObjectUtils.isArray((Object)convertedOutput) && !(convertedOutput instanceof byte[]) ? this.convertMultipleOutputValuesIfNecessary(convertedOutput, ObjectUtils.isEmpty((Object[])contentType) ? null : contentType) : SimpleFunctionRegistry.this.messageConverter.toMessage(convertedOutput, new MessageHeaders(Collections.singletonMap("contentType", contentType == null ? "application/json" : contentType[0]))))));
            return convertedOutput;
        }

        private boolean containsRetainMessageSignalInHeaders(Message message) {
            if (SimpleFunctionRegistry.this.functionInvocationHelper != null && SimpleFunctionRegistry.this.functionInvocationHelper.isRetainOuputAsMessage((Object)message)) {
                return true;
            }
            for (String headerName : message.getHeaders().keySet()) {
                if (!headerName.startsWith("lambda") && !headerName.startsWith("scf-func-name")) continue;
                return true;
            }
            return false;
        }

        private Object convertNonMessageInputIfNecessary(Type inputType, Object input, boolean maybeJson) {
            Class<?> rawInputType;
            Object convertedInput = null;
            Class<?> clazz = rawInputType = this.isTypePublisher(inputType) || this.isInputTypeMessage() ? FunctionTypeUtils.getRawType(FunctionTypeUtils.getGenericType(inputType)) : this.getRawClassFor(inputType);
            if (maybeJson && !Message.class.isAssignableFrom(rawInputType)) {
                if (FunctionTypeUtils.isMessage(inputType)) {
                    inputType = FunctionTypeUtils.getGenericType(inputType);
                }
                if (Object.class != inputType) {
                    convertedInput = SimpleFunctionRegistry.this.jsonMapper.fromJson(input, inputType);
                }
            } else if (SimpleFunctionRegistry.this.conversionService != null && !rawInputType.equals(input.getClass()) && SimpleFunctionRegistry.this.conversionService.canConvert(input.getClass(), rawInputType)) {
                convertedInput = SimpleFunctionRegistry.this.conversionService.convert(input, rawInputType);
            }
            if (convertedInput == null && SimpleFunctionRegistry.this.logger.isDebugEnabled()) {
                SimpleFunctionRegistry.this.logger.debug((Object)("Failed to convert input '" + input + "' to type " + inputType + ". Will use it as is."));
            }
            return convertedInput == null ? input : convertedInput;
        }

        private boolean isWrapConvertedInputInMessage(Object convertedInput) {
            return this.inputType != null && FunctionTypeUtils.isMessage(this.inputType) && !(convertedInput instanceof Message) && !(convertedInput instanceof Publisher) && !(convertedInput instanceof OriginalMessageHolder);
        }

        private Type extractActualValueTypeIfNecessary(Type type) {
            if (type instanceof ParameterizedType && (FunctionTypeUtils.isPublisher(type) || FunctionTypeUtils.isMessage(type))) {
                return FunctionTypeUtils.getGenericType(type);
            }
            return type;
        }

        private boolean isConversionHintRequired(Type actualType, Class<?> rawType) {
            if (Collection.class.isAssignableFrom(rawType) || Map.class.isAssignableFrom(rawType)) {
                return true;
            }
            return rawType != actualType && !FunctionTypeUtils.isMessage(actualType);
        }

        private Object convertInputMessageIfNecessary(Message message, Type type) {
            if (type == null) {
                return null;
            }
            if (message.getPayload() instanceof Optional) {
                return message;
            }
            if (message.getPayload() instanceof Collection) {
                Class collectionType;
                Type itemType = FunctionTypeUtils.getImmediateGenericType(type, 0);
                if (itemType == null) {
                    itemType = type;
                }
                if ((collectionType = CollectionUtils.findCommonElementType((Collection)((Collection)message.getPayload()))) == itemType) {
                    return message.getPayload();
                }
            }
            Object convertedInput = message.getPayload();
            Type itemType = this.extractActualValueTypeIfNecessary(type);
            Class<?> rawType = FunctionTypeUtils.isMessage(type) ? FunctionTypeUtils.getRawType(itemType) : FunctionTypeUtils.getRawType(type);
            Object object = convertedInput = this.isConversionHintRequired(type, rawType) ? SimpleFunctionRegistry.this.messageConverter.fromMessage(message, rawType, (Object)itemType) : SimpleFunctionRegistry.this.messageConverter.fromMessage(message, rawType);
            if (convertedInput != null && !rawType.isAssignableFrom(convertedInput.getClass())) {
                SimpleFunctionRegistry.this.logger.warn((Object)("Failed to convert input to " + rawType + ". Will attempt to invoke function with raw type"));
            }
            if (FunctionTypeUtils.isMessage(type)) {
                if (convertedInput == null) {
                    if (SimpleFunctionRegistry.this.logger.isDebugEnabled()) {
                        SimpleFunctionRegistry.this.logger.debug((Object)("Input type conversion of payload " + message.getPayload() + " resulted in 'null'. Will use the original message as input."));
                    }
                    convertedInput = message;
                } else if (!(convertedInput instanceof Message)) {
                    convertedInput = MessageBuilder.withPayload((Object)convertedInput).copyHeaders((Map)message.getHeaders()).build();
                }
            }
            return convertedInput;
        }

        private Object convertMultipleOutputArgumentTypeIfNecesary(Object output, Type type, String[] contentType) {
            Type[] outputTypes = ((ParameterizedType)type).getActualTypeArguments();
            Object[] multipleValueArguments = this.parseMultipleValueArguments(output, outputTypes.length);
            Object[] convertedOutputs = new Object[outputTypes.length];
            for (int i = 0; i < multipleValueArguments.length; ++i) {
                Object convertedInput;
                String[] stringArray;
                if (!ObjectUtils.isEmpty((Object[])contentType)) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = contentType[i];
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = "application/json";
                }
                String[] ctToUse = stringArray;
                convertedOutputs[i] = convertedInput = this.convertOutputIfNecessary(multipleValueArguments[i], outputTypes[i], ctToUse);
            }
            return Tuples.fromArray((Object[])convertedOutputs);
        }

        private Object convertOutputMessageIfNecessary(Object output, String expectedOutputContetntType) {
            String contentType;
            String string = contentType = ((Message)output).getHeaders().containsKey((Object)"expected-content-type") ? (String)((Message)output).getHeaders().get((Object)"expected-content-type") : expectedOutputContetntType;
            if (StringUtils.hasText((String)contentType)) {
                String[] expectedContentTypes;
                HashMap<String, String> headersMap = new HashMap<String, String>((Map<String, String>)((Message)output).getHeaders());
                for (String expectedContentType : expectedContentTypes = StringUtils.delimitedListToStringArray((String)contentType, (String)",")) {
                    headersMap.put("contentType", expectedContentType);
                    Message message = MessageBuilder.withPayload((Object)((Message)output).getPayload()).copyHeaders(headersMap).build();
                    Message result = SimpleFunctionRegistry.this.messageConverter.toMessage(message.getPayload(), message.getHeaders());
                    if (result == null) continue;
                    return result;
                }
            }
            return output;
        }

        private Object convertMultipleOutputValuesIfNecessary(Object output, String[] contentType) {
            Collection outputCollection = ObjectUtils.isArray((Object)output) ? CollectionUtils.arrayToList((Object)output) : (Collection)output;
            AbstractCollection convertedOutputCollection = outputCollection instanceof List ? new ArrayList() : new TreeSet();
            Type type = this.isOutputTypeMessage() ? FunctionTypeUtils.getGenericType(this.outputType) : this.outputType;
            for (Object outToConvert : outputCollection) {
                Object result = this.convertOutputIfNecessary(outToConvert, type, contentType);
                Assert.notNull((Object)result, () -> "Failed to convert output '" + outToConvert + "'");
                convertedOutputCollection.add(result);
            }
            return ObjectUtils.isArray((Object)output) ? convertedOutputCollection.toArray() : convertedOutputCollection;
        }

        private Object convertInputPublisherIfNecessary(Publisher publisher, Type type) {
            if (FunctionTypeUtils.isMono(type) && publisher instanceof Flux) {
                publisher = Mono.from((Publisher)publisher);
            } else if (FunctionTypeUtils.isFlux(type) && publisher instanceof Mono) {
                publisher = Flux.from((Publisher)publisher);
            }
            Type actualType = type != null && FunctionTypeUtils.isPublisher(type) ? FunctionTypeUtils.getImmediateGenericType(type, 0) : type;
            return publisher instanceof Mono ? Mono.from((Publisher)publisher).map(v -> {
                try {
                    return this.convertInputIfNecessary(v, actualType == null ? type : actualType);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to convert input", e);
                }
            }) : Flux.from((Publisher)publisher).map(v -> {
                try {
                    return this.convertInputIfNecessary(v, actualType == null ? type : actualType);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to convert input", e);
                }
            });
        }

        private Object convertOutputPublisherIfNecessary(Publisher publisher, Type type, String[] expectedOutputContentType) {
            return publisher instanceof Mono ? Mono.from((Publisher)publisher).map(v -> {
                try {
                    return this.convertOutputIfNecessary(v, type, expectedOutputContentType);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to convert output", e);
                }
            }) : Flux.from((Publisher)publisher).map(v -> {
                try {
                    return this.convertOutputIfNecessary(v, type, expectedOutputContentType);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to convert output", e);
                }
            });
        }

        static /* synthetic */ String[] access$002(FunctionInvocationWrapper x0, String[] x1) {
            x0.expectedOutputContentType = x1;
            return x1;
        }
    }
}

