/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.deployer;

import java.lang.reflect.Field;
import java.net.URL;
import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.cloud.function.context.FunctionalSpringApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.SimpleCommandLinePropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class ContextRunner {
    private ConfigurableApplicationContext context;
    private Thread runThread;
    private volatile boolean running = false;
    private Throwable error;
    private long timeout = 120000L;

    public void run(final String source, final Map<String, Object> properties, final String ... args) {
        this.runThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ContextRunner.this.resetUrlHandler();
                    StandardEnvironment environment = new StandardEnvironment();
                    environment.getPropertySources().addAfter("systemEnvironment", (PropertySource)new MapPropertySource("appDeployer", properties));
                    if (args != null && args.length > 0) {
                        environment.getPropertySources().addFirst((PropertySource)new SimpleCommandLinePropertySource("args", args));
                    }
                    ContextRunner.this.running = true;
                    Class sourceClass = ClassUtils.resolveClassName((String)source, null);
                    SpringApplication builder = ContextRunner.this.builder(sourceClass, environment);
                    ContextRunner.this.context = builder.run(args);
                }
                catch (Throwable ex) {
                    ContextRunner.this.error = ex;
                }
            }
        });
        this.runThread.start();
        try {
            this.runThread.join(this.timeout);
            this.running = this.context != null && this.context.isRunning();
        }
        catch (InterruptedException e) {
            this.running = false;
            Thread.currentThread().interrupt();
        }
    }

    public void close() {
        if (this.context != null) {
            this.context.close();
            this.resetUrlHandler();
        }
        this.running = false;
        this.runThread.setContextClassLoader(null);
        this.runThread = null;
    }

    public ConfigurableApplicationContext getContext() {
        return this.context;
    }

    private void resetUrlHandler() {
        if (ClassUtils.isPresent((String)"org.apache.catalina.webresources.TomcatURLStreamHandlerFactory", null)) {
            this.setField(ClassUtils.resolveClassName((String)"org.apache.catalina.webresources.TomcatURLStreamHandlerFactory", null), "instance", null);
            this.setField(URL.class, "factory", null);
        }
    }

    private void setField(Class<?> type, String name, Object value) {
        Field field = ReflectionUtils.findField(type, (String)name);
        ReflectionUtils.makeAccessible((Field)field);
        ReflectionUtils.setField((Field)field, null, (Object)value);
    }

    public boolean isRunning() {
        return this.running;
    }

    public Throwable getError() {
        return this.error;
    }

    private SpringApplication builder(Class<?> type, StandardEnvironment environment) {
        SpringApplication application = !ContextRunner.isFunctional(environment) ? new SpringApplication(new Class[]{type}) : FunctionalSpringApplicationCreator.create(type);
        application.setEnvironment((ConfigurableEnvironment)environment);
        application.setRegisterShutdownHook(false);
        return application;
    }

    private static boolean isFunctional(StandardEnvironment environment) {
        if (!ClassUtils.isPresent((String)"org.springframework.cloud.function.context.FunctionalSpringApplication", null)) {
            return false;
        }
        return environment.resolvePlaceholders("${spring.functional.enabled:true}").equals("true");
    }

    private static class FunctionalSpringApplicationCreator {
        private FunctionalSpringApplicationCreator() {
        }

        public static SpringApplication create(Class<?> type) {
            return new FunctionalSpringApplication(new Class[]{type});
        }
    }
}

