/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.deployer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.DefaultApplicationArguments;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.loader.archive.Archive;
import org.springframework.boot.loader.archive.ExplodedArchive;
import org.springframework.boot.loader.archive.JarFileArchive;
import org.springframework.cloud.deployer.resource.maven.MavenProperties;
import org.springframework.cloud.deployer.resource.maven.MavenResourceLoader;
import org.springframework.cloud.function.context.FunctionRegistry;
import org.springframework.cloud.function.deployer.FunctionArchiveDeployer;
import org.springframework.cloud.function.deployer.FunctionDeployerProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={FunctionDeployerProperties.class})
@ConditionalOnProperty(name={"spring.cloud.function.location"})
public class FunctionDeployerConfiguration {
    private static Log logger = LogFactory.getLog(FunctionDeployerConfiguration.class);

    @Bean
    SmartLifecycle functionArchiveUnDeployer(final FunctionDeployerProperties functionProperties, FunctionRegistry functionRegistry, ApplicationArguments arguments, @Nullable MavenProperties mavenProperties, ApplicationContext applicationContext) {
        ApplicationArguments updatedArguments = this.updateArguments(arguments);
        Object archive = null;
        try {
            File file;
            String location = functionProperties.getLocation();
            Assert.hasText((String)location, (String)"`spring.cloud.function.location` property must be defined.");
            if (location.startsWith("maven://")) {
                MavenResourceLoader resourceLoader = new MavenResourceLoader(mavenProperties);
                file = resourceLoader.getResource(location).getFile();
            } else {
                file = new File(location);
            }
            if (!file.exists()) {
                throw new IllegalStateException("Failed to create archive: " + functionProperties.getLocation() + " does not exist");
            }
            archive = file.isDirectory() ? new ExplodedArchive(file) : new JarFileArchive(file);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create archive: " + functionProperties.getLocation(), e);
        }
        final FunctionArchiveDeployer deployer = new FunctionArchiveDeployer((Archive)archive);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Deploying archive: " + functionProperties.getLocation()));
        }
        deployer.deploy(functionRegistry, functionProperties, updatedArguments.getSourceArgs(), applicationContext);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Successfully deployed archive: " + functionProperties.getLocation()));
        }
        return new SmartLifecycle(){
            private boolean running = true;

            public void stop() {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Undeploying archive: " + functionProperties.getLocation()));
                }
                deployer.undeploy();
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Successfully undeployed archive: " + functionProperties.getLocation()));
                }
                this.running = false;
            }

            public void start() {
            }

            public boolean isRunning() {
                return this.running;
            }

            public int getPhase() {
                return 2147482647;
            }
        };
    }

    private ApplicationArguments updateArguments(ApplicationArguments arguments) {
        ArrayList<String> originalArguments = new ArrayList<String>(Arrays.asList(arguments.getSourceArgs()));
        if (arguments.containsOption("function.name")) {
            originalArguments.add("spring.cloud.function.definition=" + (String)arguments.getOptionValues("function.name").get(0));
        }
        if (arguments.containsOption("function.location")) {
            originalArguments.add("spring.cloud.function.location=" + (String)arguments.getOptionValues("function.location").get(0));
        }
        DefaultApplicationArguments updatedArguments = new DefaultApplicationArguments(originalArguments.toArray(new String[0]));
        return updatedArguments;
    }

    static class LegacyPropertyEnvironmentPostProcessor
    implements EnvironmentPostProcessor {
        LegacyPropertyEnvironmentPostProcessor() {
        }

        public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
            String functionLocation;
            String functionName = environment.containsProperty("function.name") ? environment.getProperty("function.name") : null;
            String string = functionLocation = environment.containsProperty("function.location") ? environment.getProperty("function.location") : null;
            if (StringUtils.hasText((String)functionName) || StringUtils.hasText((String)functionLocation)) {
                MutablePropertySources propertySources = environment.getPropertySources();
                propertySources.forEach(ps -> {
                    if (ps instanceof PropertiesPropertySource) {
                        ((Map)((MapPropertySource)ps).getSource()).put("spring.cloud.function.definition", functionName);
                        ((Map)((MapPropertySource)ps).getSource()).put("spring.cloud.function.location", functionLocation);
                    }
                });
            }
        }
    }
}

