/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.flux;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.cloud.function.context.catalog.FunctionInspector;
import org.springframework.cloud.function.context.message.MessageUtils;
import org.springframework.cloud.function.web.flux.StringConverter;
import org.springframework.cloud.function.web.flux.constants.WebRequestConstants;
import org.springframework.cloud.function.web.flux.request.FluxFormRequest;
import org.springframework.cloud.function.web.flux.request.FluxRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.WebRequest;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class FunctionController {
    private static Log logger = LogFactory.getLog(FunctionController.class);
    private FunctionInspector inspector;
    private boolean debug = false;
    private StringConverter converter;

    public FunctionController(FunctionInspector inspector, StringConverter converter) {
        this.inspector = inspector;
        this.converter = converter;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @PostMapping(path={"/**"})
    @ResponseBody
    public ResponseEntity<Publisher<?>> post(WebRequest request, @RequestBody FluxRequest<?> body) {
        Function function = (Function)request.getAttribute(WebRequestConstants.FUNCTION, 0);
        Consumer consumer = (Consumer)request.getAttribute(WebRequestConstants.CONSUMER, 0);
        Boolean single = (Boolean)request.getAttribute(WebRequestConstants.INPUT_SINGLE, 0);
        FluxFormRequest form = FluxFormRequest.from(request.getParameterMap());
        if (function != null) {
            Flux flux;
            Flux flux2 = flux = body.body() == null ? form.flux() : body.flux();
            if (this.debug) {
                flux = flux.log();
            }
            Flux result = Flux.from((Publisher)((Publisher)function.apply(flux)));
            if (this.inspector.isMessage((Object)function)) {
                result = result.map(message -> MessageUtils.unpack((Object)function, (Object)message));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Handled POST with function");
            }
            return ResponseEntity.ok().body((Object)(this.debug ? result.log() : this.response(request, function, single, (Publisher<?>)result)));
        }
        if (consumer != null) {
            Flux flux;
            Flux flux3 = flux = body.body() == null ? form.flux().cache() : body.flux().cache();
            if (this.debug) {
                flux = flux.log();
            }
            consumer.accept(flux);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Handled POST with consumer");
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.ACCEPTED).body((Object)flux);
        }
        throw new IllegalArgumentException("no such function");
    }

    private Publisher<?> response(WebRequest request, Object handler, Boolean single, Publisher<?> result) {
        if (single != null && single.booleanValue() && this.isOutputSingle(handler)) {
            request.setAttribute(WebRequestConstants.OUTPUT_SINGLE, (Object)true, 0);
            return Mono.from(result);
        }
        if (this.isInputMultiple(handler) && this.isOutputSingle(handler)) {
            request.setAttribute(WebRequestConstants.OUTPUT_SINGLE, (Object)true, 0);
            return Mono.from(result);
        }
        request.setAttribute(WebRequestConstants.OUTPUT_SINGLE, (Object)false, 0);
        return result;
    }

    private boolean isInputMultiple(Object handler) {
        Class type = this.inspector.getInputType(handler);
        Class wrapper = this.inspector.getInputWrapper(handler);
        return Collection.class.isAssignableFrom(type) || Flux.class.equals((Object)wrapper);
    }

    private boolean isOutputSingle(Object handler) {
        Class type = this.inspector.getOutputType(handler);
        Class wrapper = this.inspector.getOutputWrapper(handler);
        if (Stream.class.isAssignableFrom(type)) {
            return false;
        }
        if (wrapper == type) {
            return true;
        }
        return Mono.class.equals((Object)wrapper) || Optional.class.equals((Object)wrapper);
    }

    @GetMapping(path={"/**"})
    @ResponseBody
    public Publisher<?> get(WebRequest request) {
        Function function = (Function)request.getAttribute(WebRequestConstants.FUNCTION, 0);
        Supplier supplier = (Supplier)request.getAttribute(WebRequestConstants.SUPPLIER, 0);
        String argument = (String)request.getAttribute(WebRequestConstants.ARGUMENT, 0);
        if (function != null) {
            return this.value(function, argument);
        }
        return this.response(request, supplier, true, this.supplier(supplier));
    }

    private Publisher<?> supplier(Supplier<Publisher<?>> supplier) {
        Flux result = supplier.get();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Handled GET with supplier");
        }
        return this.debug ? Flux.from(result).log() : result;
    }

    private Mono<?> value(Function<Publisher<?>, Publisher<?>> function, String value) {
        Object input = this.converter.convert(function, value);
        Mono result = Mono.from(function.apply((Publisher<?>)Flux.just((Object)input)));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Handled GET with function");
        }
        return this.debug ? result.log() : result;
    }
}

