/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.handler;

import org.springframework.cloud.gateway.server.mvc.filter.BeforeFilterFunctions;
import org.springframework.cloud.gateway.server.mvc.handler.GatewayRouterFunctionsBuilder;
import org.springframework.web.servlet.function.HandlerFunction;
import org.springframework.web.servlet.function.RequestPredicate;
import org.springframework.web.servlet.function.RouterFunction;
import org.springframework.web.servlet.function.RouterFunctions;
import org.springframework.web.servlet.function.ServerResponse;

public abstract class GatewayRouterFunctions {
    private GatewayRouterFunctions() {
    }

    public static RouterFunctions.Builder route() {
        return RouterFunctions.route();
    }

    public static RouterFunctions.Builder route(String routeId) {
        RouterFunctions.Builder builder = RouterFunctions.route().before(BeforeFilterFunctions.routeId(routeId));
        return new GatewayRouterFunctionsBuilder(builder, routeId);
    }

    public static <T extends ServerResponse> RouterFunction<T> route(RequestPredicate predicate, HandlerFunction<T> handlerFunction) {
        return RouterFunctions.route((RequestPredicate)predicate, handlerFunction);
    }
}

