/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.route.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.PredicateSpec;
import org.springframework.context.ConfigurableApplicationContext;
import reactor.core.publisher.Flux;

public class RouteLocatorBuilder {
    private ConfigurableApplicationContext context;

    public RouteLocatorBuilder(ConfigurableApplicationContext context) {
        this.context = context;
    }

    public Builder routes() {
        return new Builder(this.context);
    }

    public static class RouteSpec {
        private final Route.AsyncBuilder routeBuilder = Route.async();
        private final Builder builder;

        RouteSpec(Builder builder) {
            this.builder = builder;
        }

        public PredicateSpec id(String id) {
            this.routeBuilder.id(id);
            return this.predicateBuilder();
        }

        public PredicateSpec randomId() {
            return this.id(UUID.randomUUID().toString());
        }

        private PredicateSpec predicateBuilder() {
            return new PredicateSpec(this.routeBuilder, this.builder);
        }
    }

    public static class Builder {
        private List<Route.AsyncBuilder> routes = new ArrayList<Route.AsyncBuilder>();
        private ConfigurableApplicationContext context;

        public Builder(ConfigurableApplicationContext context) {
            this.context = context;
        }

        public Builder route(String id, Function<PredicateSpec, Route.AsyncBuilder> fn) {
            Route.AsyncBuilder routeBuilder = fn.apply(new RouteSpec(this).id(id));
            this.add(routeBuilder);
            return this;
        }

        public Builder route(Function<PredicateSpec, Route.AsyncBuilder> fn) {
            Route.AsyncBuilder routeBuilder = fn.apply(new RouteSpec(this).randomId());
            this.add(routeBuilder);
            return this;
        }

        public RouteLocator build() {
            return () -> Flux.fromIterable(this.routes).map(routeBuilder -> routeBuilder.build());
        }

        ConfigurableApplicationContext getContext() {
            return this.context;
        }

        void add(Route.AsyncBuilder route) {
            this.routes.add(route);
        }
    }
}

