/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import java.net.URI;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.Ordered;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class WebClientHttpRoutingFilter
implements GlobalFilter,
Ordered {
    private final WebClient webClient;
    private final ObjectProvider<List<HttpHeadersFilter>> headersFiltersProvider;
    private volatile List<HttpHeadersFilter> headersFilters;

    public WebClientHttpRoutingFilter(WebClient webClient, ObjectProvider<List<HttpHeadersFilter>> headersFiltersProvider) {
        this.webClient = webClient;
        this.headersFiltersProvider = headersFiltersProvider;
    }

    public List<HttpHeadersFilter> getHeadersFilters() {
        if (this.headersFilters == null) {
            this.headersFilters = (List)this.headersFiltersProvider.getIfAvailable();
        }
        return this.headersFilters;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        URI requestUrl = (URI)exchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        String scheme = requestUrl.getScheme();
        if (ServerWebExchangeUtils.isAlreadyRouted(exchange) || !"http".equals(scheme) && !"https".equals(scheme)) {
            return chain.filter(exchange);
        }
        ServerWebExchangeUtils.setAlreadyRouted(exchange);
        ServerHttpRequest request = exchange.getRequest();
        HttpMethod method = request.getMethod();
        HttpHeaders filteredHeaders = HttpHeadersFilter.filterRequest(this.getHeadersFilters(), exchange);
        boolean preserveHost = (Boolean)exchange.getAttributeOrDefault(ServerWebExchangeUtils.PRESERVE_HOST_HEADER_ATTRIBUTE, (Object)false);
        WebClient.RequestBodySpec bodySpec = (WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.method(method).uri(requestUrl)).headers(httpHeaders -> {
            httpHeaders.addAll((MultiValueMap)filteredHeaders);
            if (!preserveHost) {
                httpHeaders.remove((Object)"Host");
            }
        });
        Object headersSpec = this.requiresBody(method) ? bodySpec.body(BodyInserters.fromDataBuffers((Publisher)request.getBody())) : bodySpec;
        return headersSpec.exchangeToMono(Mono::just).flatMap(res -> {
            ServerHttpResponse response = exchange.getResponse();
            response.getHeaders().putAll((Map)res.headers().asHttpHeaders());
            response.setStatusCode(res.statusCode());
            exchange.getAttributes().put(ServerWebExchangeUtils.CLIENT_RESPONSE_ATTR, res);
            return chain.filter(exchange);
        });
    }

    private boolean requiresBody(HttpMethod method) {
        return method.equals((Object)HttpMethod.PUT) || method.equals((Object)HttpMethod.POST) || method.equals((Object)HttpMethod.PATCH);
    }
}

