/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.support;

import org.springframework.cloud.gateway.filter.factory.AddRequestHeadersIfNotPresentGatewayFilterFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.StringUtils;

public class KeyValueConverter
implements Converter<String, AddRequestHeadersIfNotPresentGatewayFilterFactory.KeyValue> {
    private static final String INVALID_CONFIGURATION_MESSAGE = "Invalid configuration, expected format is: 'key:value'";

    public AddRequestHeadersIfNotPresentGatewayFilterFactory.KeyValue convert(String source) throws IllegalArgumentException {
        try {
            String[] split = source.split(":");
            if (source.contains(":") && StringUtils.hasText((String)split[0])) {
                return new AddRequestHeadersIfNotPresentGatewayFilterFactory.KeyValue(split[0], split.length == 1 ? "" : split[1]);
            }
            throw new IllegalArgumentException(INVALID_CONFIGURATION_MESSAGE);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException(INVALID_CONFIGURATION_MESSAGE);
        }
    }
}

