/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.cache;

import java.time.Duration;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.Cache;
import org.springframework.cloud.gateway.config.LocalResponseCacheAutoConfiguration;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.cache.LocalResponseCacheProperties;
import org.springframework.cloud.gateway.filter.factory.cache.ResponseCacheGatewayFilter;
import org.springframework.cloud.gateway.filter.factory.cache.ResponseCacheManagerFactory;
import org.springframework.cloud.gateway.support.HasRouteId;
import org.springframework.util.unit.DataSize;
import org.springframework.validation.annotation.Validated;

@ConditionalOnProperty(value={"spring.cloud.gateway.filter.local-response-cache.enabled"}, havingValue="true")
public class LocalResponseCacheGatewayFilterFactory
extends AbstractGatewayFilterFactory<RouteCacheConfiguration> {
    public static final String LOCAL_RESPONSE_CACHE_FILTER_APPLIED = "LocalResponseCacheGatewayFilter-Applied";
    private ResponseCacheManagerFactory cacheManagerFactory;
    private Duration defaultTimeToLive;
    private DataSize defaultSize;

    public LocalResponseCacheGatewayFilterFactory(ResponseCacheManagerFactory cacheManagerFactory, Duration defaultTimeToLive) {
        this(cacheManagerFactory, defaultTimeToLive, null);
    }

    public LocalResponseCacheGatewayFilterFactory(ResponseCacheManagerFactory cacheManagerFactory, Duration defaultTimeToLive, DataSize defaultSize) {
        super(RouteCacheConfiguration.class);
        this.cacheManagerFactory = cacheManagerFactory;
        this.defaultTimeToLive = defaultTimeToLive;
        this.defaultSize = defaultSize;
    }

    @Override
    public GatewayFilter apply(RouteCacheConfiguration config) {
        LocalResponseCacheProperties cacheProperties = this.mapRouteCacheConfig(config);
        Cache routeCache = LocalResponseCacheAutoConfiguration.createGatewayCacheManager(cacheProperties).getCache(config.getRouteId() + "-cache");
        return new ResponseCacheGatewayFilter(this.cacheManagerFactory.create(routeCache, cacheProperties.getTimeToLive()));
    }

    private LocalResponseCacheProperties mapRouteCacheConfig(RouteCacheConfiguration config) {
        Duration timeToLive = config.getTimeToLive() != null ? config.getTimeToLive() : this.defaultTimeToLive;
        DataSize size = config.getSize() != null ? config.getSize() : this.defaultSize;
        LocalResponseCacheProperties responseCacheProperties = new LocalResponseCacheProperties();
        responseCacheProperties.setTimeToLive(timeToLive);
        responseCacheProperties.setSize(size);
        return responseCacheProperties;
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return List.of("timeToLive", "size");
    }

    @Validated
    public static class RouteCacheConfiguration
    implements HasRouteId {
        private DataSize size;
        private Duration timeToLive;
        private String routeId;

        public DataSize getSize() {
            return this.size;
        }

        public RouteCacheConfiguration setSize(DataSize size) {
            this.size = size;
            return this;
        }

        public Duration getTimeToLive() {
            return this.timeToLive;
        }

        public RouteCacheConfiguration setTimeToLive(Duration timeToLive) {
            this.timeToLive = timeToLive;
            return this;
        }

        @Override
        public void setRouteId(String routeId) {
            this.routeId = routeId;
        }

        @Override
        public String getRouteId() {
            return this.routeId;
        }
    }
}

