/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.cache.postprocessor;

import java.time.Clock;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.cloud.gateway.filter.factory.cache.CachedResponse;
import org.springframework.cloud.gateway.filter.factory.cache.postprocessor.AfterCacheExchangeMutator;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;

public class SetMaxAgeHeaderAfterCacheExchangeMutator
implements AfterCacheExchangeMutator {
    private static final String MAX_AGE_PREFIX = "max-age=";
    private final Duration configuredTimeToLive;
    private final Clock clock;

    public SetMaxAgeHeaderAfterCacheExchangeMutator(Duration configuredTimeToLive, Clock clock) {
        this.configuredTimeToLive = configuredTimeToLive;
        this.clock = clock;
    }

    @Override
    public void accept(ServerWebExchange exchange, CachedResponse cachedResponse) {
        ServerHttpResponse response = exchange.getResponse();
        long calculatedMaxAgeInSeconds = this.calculateMaxAgeInSeconds(cachedResponse, this.configuredTimeToLive);
        SetMaxAgeHeaderAfterCacheExchangeMutator.rewriteCacheControlMaxAge(response.getHeaders(), calculatedMaxAgeInSeconds);
    }

    private long calculateMaxAgeInSeconds(CachedResponse cachedResponse, Duration configuredTimeToLive) {
        long maxAge = configuredTimeToLive.getSeconds() == -1L ? -1L : Math.max(0L, configuredTimeToLive.minus(this.getElapsedTimeInSeconds(cachedResponse)).getSeconds());
        return maxAge;
    }

    private Duration getElapsedTimeInSeconds(CachedResponse cachedResponse) {
        return Duration.ofMillis(this.clock.millis() - cachedResponse.timestamp().getTime());
    }

    private static void rewriteCacheControlMaxAge(HttpHeaders headers, long seconds) {
        boolean isMaxAgePresent;
        boolean bl = isMaxAgePresent = headers.getCacheControl() != null && headers.getCacheControl().contains(MAX_AGE_PREFIX);
        if (isMaxAgePresent) {
            List cacheControlHeaders = headers.get((Object)"Cache-Control");
            cacheControlHeaders = cacheControlHeaders == null ? Collections.emptyList() : cacheControlHeaders;
            ArrayList<String> replacedCacheControlHeaders = new ArrayList<String>();
            for (String value : cacheControlHeaders) {
                if (value.contains(MAX_AGE_PREFIX)) {
                    if (seconds == -1L) {
                        List removedMaxAgeList = Arrays.stream(value.split(",")).filter(i -> !i.trim().startsWith(MAX_AGE_PREFIX)).collect(Collectors.toList());
                        value = String.join((CharSequence)",", removedMaxAgeList);
                    } else {
                        value = value.replaceFirst("\\bmax-age=\\d+\\b", MAX_AGE_PREFIX + seconds);
                    }
                }
                replacedCacheControlHeaders.add(value);
            }
            headers.remove((Object)"Cache-Control");
            headers.addAll("Cache-Control", replacedCacheControlHeaders);
        }
    }
}

