/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.gateway.filter.FilterDefinition;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.core.style.ToStringCreator;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value="spring.cloud.gateway.server.webflux")
@Validated
public class GatewayProperties {
    public static final String PREFIX = "spring.cloud.gateway.server.webflux";
    private final Log logger = LogFactory.getLog(this.getClass());
    @NotNull
    @Valid
    private List<RouteDefinition> routes = new ArrayList<RouteDefinition>();
    private List<FilterDefinition> defaultFilters = new ArrayList<FilterDefinition>();
    private List<MediaType> streamingMediaTypes = Arrays.asList(MediaType.TEXT_EVENT_STREAM, new MediaType("application", "stream+json"), new MediaType("application", "grpc"), new MediaType("application", "grpc+protobuf"), new MediaType("application", "grpc+json"));
    private boolean failOnRouteDefinitionError = true;
    private boolean routeFilterCacheEnabled = false;
    private String trustedProxies;

    public boolean isRouteFilterCacheEnabled() {
        return this.routeFilterCacheEnabled;
    }

    public void setRouteFilterCacheEnabled(boolean routeFilterCacheEnabled) {
        this.routeFilterCacheEnabled = routeFilterCacheEnabled;
    }

    public List<RouteDefinition> getRoutes() {
        return this.routes;
    }

    public void setRoutes(List<RouteDefinition> routes) {
        this.routes = routes;
        if (routes != null && routes.size() > 0 && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Routes supplied from Gateway Properties: " + routes));
        }
    }

    public List<FilterDefinition> getDefaultFilters() {
        return this.defaultFilters;
    }

    public void setDefaultFilters(List<FilterDefinition> defaultFilters) {
        this.defaultFilters = defaultFilters;
    }

    public List<MediaType> getStreamingMediaTypes() {
        return this.streamingMediaTypes;
    }

    public void setStreamingMediaTypes(List<MediaType> streamingMediaTypes) {
        this.streamingMediaTypes = streamingMediaTypes;
    }

    public boolean isFailOnRouteDefinitionError() {
        return this.failOnRouteDefinitionError;
    }

    public void setFailOnRouteDefinitionError(boolean failOnRouteDefinitionError) {
        this.failOnRouteDefinitionError = failOnRouteDefinitionError;
    }

    public String getTrustedProxies() {
        return this.trustedProxies;
    }

    public void setTrustedProxies(String trustedProxies) {
        this.trustedProxies = trustedProxies;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("routes", this.routes).append("defaultFilters", this.defaultFilters).append("streamingMediaTypes", this.streamingMediaTypes).append("failOnRouteDefinitionError", this.failOnRouteDefinitionError).append("routeFilterCacheEnabled", this.routeFilterCacheEnabled).append("trustedProxies", (Object)this.trustedProxies).toString();
    }
}

