/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.cache;

import com.github.benmanes.caffeine.cache.Weigher;
import java.nio.Buffer;
import java.util.Collection;
import java.util.stream.Stream;
import org.springframework.cloud.gateway.filter.factory.cache.CachedResponse;

public class ResponseCacheSizeWeigher
implements Weigher<String, Object> {
    public int weigh(String key, Object value) {
        if (value instanceof CachedResponse) {
            CachedResponse cached = (CachedResponse)value;
            return cached.headers().getContentLength() > -1L ? (int)cached.headers().getContentLength() : this.estimateContentLength(cached);
        }
        return 0;
    }

    private int estimateContentLength(CachedResponse value) {
        return Stream.ofNullable(value.body()).flatMap(Collection::stream).mapToInt(Buffer::limit).sum();
    }
}

