/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import jakarta.validation.constraints.NotEmpty;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.springframework.cloud.gateway.handler.predicate.AbstractRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.GatewayPredicate;
import org.springframework.web.server.ServerWebExchange;

public class CookieRoutePredicateFactory
extends AbstractRoutePredicateFactory<Config> {
    public static final String NAME_KEY = "name";
    public static final String REGEXP_KEY = "regexp";

    public CookieRoutePredicateFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList(NAME_KEY, REGEXP_KEY);
    }

    @Override
    public Predicate<ServerWebExchange> apply(final Config config) {
        return new GatewayPredicate(){

            @Override
            public boolean test(ServerWebExchange exchange) {
                List cookies = (List)exchange.getRequest().getCookies().get((Object)config.name);
                if (cookies == null) {
                    return false;
                }
                return cookies.stream().anyMatch(cookie -> cookie.getValue().matches(config2.regexp));
            }

            @Override
            public Object getConfig() {
                return config;
            }

            public String toString() {
                return String.format("Cookie: name=%s regexp=%s", config.name, config.regexp);
            }
        };
    }

    public static class Config {
        @NotEmpty
        private String name;
        @NotEmpty
        private String regexp;

        public String getName() {
            return this.name;
        }

        public Config setName(String name) {
            this.name = name;
            return this;
        }

        public String getRegexp() {
            return this.regexp;
        }

        public Config setRegexp(String regexp) {
            this.regexp = regexp;
            return this;
        }
    }
}

