/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.vision;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.cloud.vision.v1.ImageAnnotatorClient;
import com.google.cloud.vision.v1.ImageAnnotatorSettings;
import java.io.IOException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.gcp.autoconfigure.vision.CloudVisionProperties;
import org.springframework.cloud.gcp.core.CredentialsSupplier;
import org.springframework.cloud.gcp.core.DefaultCredentialsProvider;
import org.springframework.cloud.gcp.core.UserAgentHeaderProvider;
import org.springframework.cloud.gcp.vision.CloudVisionTemplate;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={CloudVisionProperties.class})
@ConditionalOnClass(value={CloudVisionTemplate.class})
@ConditionalOnProperty(value={"spring.cloud.gcp.vision.enabled"}, matchIfMissing=true)
public class CloudVisionAutoConfiguration {
    private final CredentialsProvider credentialsProvider;

    public CloudVisionAutoConfiguration(CloudVisionProperties properties, CredentialsProvider credentialsProvider) throws IOException {
        this.credentialsProvider = properties.getCredentials().hasKey() ? new DefaultCredentialsProvider((CredentialsSupplier)properties) : credentialsProvider;
    }

    @Bean
    @ConditionalOnMissingBean
    public ImageAnnotatorClient imageAnnotatorClient() throws IOException {
        ImageAnnotatorSettings clientSettings = ((ImageAnnotatorSettings.Builder)((ImageAnnotatorSettings.Builder)ImageAnnotatorSettings.newBuilder().setCredentialsProvider(this.credentialsProvider)).setHeaderProvider((HeaderProvider)new UserAgentHeaderProvider(CloudVisionAutoConfiguration.class))).build();
        return ImageAnnotatorClient.create((ImageAnnotatorSettings)clientSettings);
    }

    @Bean
    @ConditionalOnMissingBean
    public CloudVisionTemplate cloudVisionTemplate(ImageAnnotatorClient imageAnnotatorClient) {
        return new CloudVisionTemplate(imageAnnotatorClient);
    }
}

