/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.pubsub.health;

import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import java.util.UUID;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.cloud.gcp.pubsub.core.PubSubTemplate;
import org.springframework.util.Assert;

public class PubSubHealthIndicator
extends AbstractHealthIndicator {
    private final PubSubTemplate pubSubTemplate;

    public PubSubHealthIndicator(PubSubTemplate pubSubTemplate) {
        super("Failed to connect to Pub/Sub APIs. Check your credentials and verify you have proper access to the service.");
        Assert.notNull((Object)pubSubTemplate, (String)"PubSubTemplate can't be null");
        this.pubSubTemplate = pubSubTemplate;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        try {
            this.pubSubTemplate.pull("subscription-" + UUID.randomUUID().toString(), Integer.valueOf(1), Boolean.valueOf(true));
        }
        catch (ApiException aex) {
            StatusCode.Code errorCode = aex.getStatusCode().getCode();
            if (errorCode == StatusCode.Code.NOT_FOUND || errorCode == StatusCode.Code.PERMISSION_DENIED) {
                builder.up();
            } else {
                builder.withException((Throwable)aex).down();
            }
        }
        catch (Exception e) {
            builder.withException((Throwable)e).down();
        }
    }
}

