/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.datastore.core.convert;

import com.google.cloud.datastore.BaseEntity;
import com.google.cloud.datastore.Value;
import com.google.cloud.datastore.ValueBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.cloud.gcp.data.datastore.core.convert.DatastoreCustomConversions;
import org.springframework.cloud.gcp.data.datastore.core.convert.DatastoreEntityConverter;
import org.springframework.cloud.gcp.data.datastore.core.convert.EntityPropertyValueProvider;
import org.springframework.cloud.gcp.data.datastore.core.convert.ObjectToKeyFactory;
import org.springframework.cloud.gcp.data.datastore.core.convert.ReadWriteConversions;
import org.springframework.cloud.gcp.data.datastore.core.convert.TwoStepsConversions;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastoreDataException;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastoreMappingContext;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastorePersistentEntity;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastorePersistentProperty;
import org.springframework.cloud.gcp.data.datastore.core.mapping.EmbeddedType;
import org.springframework.data.convert.EntityInstantiator;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.util.TypeInformation;

public class DefaultDatastoreEntityConverter
implements DatastoreEntityConverter {
    private DatastoreMappingContext mappingContext;
    private final EntityInstantiators instantiators = new EntityInstantiators();
    private final ReadWriteConversions conversions;

    public DefaultDatastoreEntityConverter(DatastoreMappingContext mappingContext, ObjectToKeyFactory objectToKeyFactory) {
        this(mappingContext, new TwoStepsConversions(new DatastoreCustomConversions(), objectToKeyFactory));
    }

    public DefaultDatastoreEntityConverter(DatastoreMappingContext mappingContext, ReadWriteConversions conversions) {
        this.mappingContext = mappingContext;
        this.conversions = conversions;
        conversions.registerEntityConverter(this);
    }

    @Override
    public ReadWriteConversions getConversions() {
        return this.conversions;
    }

    @Override
    public <T, R> Map<T, R> readAsMap(Class<T> keyType, TypeInformation<R> componentType, BaseEntity entity) {
        if (entity == null) {
            return null;
        }
        HashMap result = new HashMap();
        EntityPropertyValueProvider propertyValueProvider = new EntityPropertyValueProvider(entity, this.conversions);
        Set fieldNames = entity.getNames();
        for (String field : fieldNames) {
            result.put(this.conversions.convertOnRead((Object)field, null, keyType), propertyValueProvider.getPropertyValue(field, EmbeddedType.of(componentType), componentType));
        }
        return result;
    }

    public <R> R read(Class<R> aClass, BaseEntity entity) {
        Object instance;
        if (entity == null) {
            return null;
        }
        DatastorePersistentEntity persistentEntity = (DatastorePersistentEntity)this.mappingContext.getPersistentEntity(aClass);
        if (persistentEntity == null) {
            throw new DatastoreDataException("Unable to convert Datastore Entity to " + aClass);
        }
        EntityPropertyValueProvider propertyValueProvider = new EntityPropertyValueProvider(entity, this.conversions);
        PersistentEntityParameterValueProvider parameterValueProvider = new PersistentEntityParameterValueProvider((PersistentEntity)persistentEntity, (PropertyValueProvider)propertyValueProvider, null);
        EntityInstantiator instantiator = this.instantiators.getInstantiatorFor((PersistentEntity)persistentEntity);
        try {
            instance = instantiator.createInstance((PersistentEntity)persistentEntity, (ParameterValueProvider)parameterValueProvider);
            PersistentPropertyAccessor accessor = persistentEntity.getPropertyAccessor(instance);
            persistentEntity.doWithColumnBackedProperties((PropertyHandler<DatastorePersistentProperty>)((PropertyHandler)datastorePersistentProperty -> {
                if (!persistentEntity.isConstructorArgument(datastorePersistentProperty)) {
                    Object value = propertyValueProvider.getPropertyValue((DatastorePersistentProperty)datastorePersistentProperty);
                    accessor.setProperty(datastorePersistentProperty, value);
                }
            }));
        }
        catch (DatastoreDataException ex) {
            throw new DatastoreDataException("Unable to read " + persistentEntity.getName() + " entity", (Throwable)((Object)ex));
        }
        return (R)instance;
    }

    public void write(Object source, BaseEntity.Builder sink) {
        DatastorePersistentEntity persistentEntity = (DatastorePersistentEntity)this.mappingContext.getPersistentEntity(source.getClass());
        PersistentPropertyAccessor accessor = persistentEntity.getPropertyAccessor(source);
        persistentEntity.doWithColumnBackedProperties((PropertyHandler<DatastorePersistentProperty>)((PropertyHandler)persistentProperty -> {
            try {
                Object val = accessor.getProperty(persistentProperty);
                Value convertedVal = this.conversions.convertOnWrite(val, (DatastorePersistentProperty)persistentProperty);
                if (persistentProperty.isUnindexed()) {
                    ValueBuilder valueBuilder = convertedVal.toBuilder();
                    valueBuilder.setExcludeFromIndexes(true);
                    convertedVal = valueBuilder.build();
                }
                sink.set(persistentProperty.getFieldName(), convertedVal);
            }
            catch (DatastoreDataException ex) {
                throw new DatastoreDataException("Unable to write " + persistentEntity.kindName() + "." + persistentProperty.getFieldName(), (Throwable)((Object)ex));
            }
        }));
    }
}

