/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.datastore.core.mapping;

import com.google.common.annotations.VisibleForTesting;
import org.springframework.beans.BeansException;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastorePersistentEntity;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastorePersistentEntityImpl;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastorePersistentProperty;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastorePersistentPropertyImpl;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.AbstractMappingContext;
import org.springframework.data.mapping.model.FieldNamingStrategy;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.PropertyNameFieldNamingStrategy;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.TypeInformation;

public class DatastoreMappingContext
extends AbstractMappingContext<DatastorePersistentEntity<?>, DatastorePersistentProperty>
implements ApplicationContextAware {
    private static final FieldNamingStrategy DEFAULT_NAMING_STRATEGY = PropertyNameFieldNamingStrategy.INSTANCE;
    private final FieldNamingStrategy fieldNamingStrategy = DEFAULT_NAMING_STRATEGY;
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @VisibleForTesting
    protected <T> DatastorePersistentEntityImpl<T> constructPersistentEntity(TypeInformation<T> typeInformation) {
        return new DatastorePersistentEntityImpl<T>(typeInformation);
    }

    protected <T> DatastorePersistentEntity<?> createPersistentEntity(TypeInformation<T> typeInformation) {
        DatastorePersistentEntityImpl<T> persistentEntity = this.constructPersistentEntity(typeInformation);
        if (this.applicationContext != null) {
            persistentEntity.setApplicationContext(this.applicationContext);
        }
        return persistentEntity;
    }

    protected DatastorePersistentProperty createPersistentProperty(Property property, DatastorePersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder) {
        return new DatastorePersistentPropertyImpl(property, (PersistentEntity<?, DatastorePersistentProperty>)owner, simpleTypeHolder, this.fieldNamingStrategy);
    }
}

