/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.datastore.repository.support;

import com.google.cloud.datastore.Key;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.cloud.gcp.data.datastore.core.DatastoreOperations;
import org.springframework.cloud.gcp.data.datastore.core.DatastoreQueryOptions;
import org.springframework.cloud.gcp.data.datastore.repository.DatastoreRepository;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;

public class SimpleDatastoreRepository<T, ID>
implements DatastoreRepository<T, ID> {
    private final DatastoreOperations datastoreTemplate;
    private final Class<T> entityType;

    public SimpleDatastoreRepository(DatastoreOperations datastoreTemplate, Class<T> entityType) {
        Assert.notNull((Object)datastoreTemplate, (String)"A non-null DatastoreOperations is required.");
        Assert.notNull(entityType, (String)"A non-null entity type is required.");
        this.datastoreTemplate = datastoreTemplate;
        this.entityType = entityType;
    }

    @Override
    public <A> A performTransaction(Function<DatastoreRepository<T, ID>, A> operations) {
        return (A)this.datastoreTemplate.performTransaction((DatastoreOperations template) -> operations.apply(new SimpleDatastoreRepository<T, ID>((DatastoreOperations)template, this.entityType)));
    }

    public Iterable<T> findAll(Sort sort) {
        Assert.notNull((Object)sort, (String)"A non-null Sort is required.");
        return this.datastoreTemplate.findAll(this.entityType, new DatastoreQueryOptions(null, null, sort));
    }

    public Page<T> findAll(Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"A non-null Pageable is required.");
        return new PageImpl(new ArrayList<T>(this.datastoreTemplate.findAll(this.entityType, new DatastoreQueryOptions(pageable.getPageSize(), (int)pageable.getOffset(), pageable.getSort()))), pageable, this.datastoreTemplate.count(this.entityType));
    }

    public <S extends T> S save(S entity) {
        return this.datastoreTemplate.save(entity, new Key[0]);
    }

    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        return this.datastoreTemplate.saveAll(entities, new Key[0]);
    }

    public Optional<T> findById(ID id) {
        return Optional.ofNullable(this.datastoreTemplate.findById(id, this.entityType));
    }

    public boolean existsById(ID id) {
        return this.datastoreTemplate.existsById(id, this.entityType);
    }

    public Iterable<T> findAll() {
        return this.datastoreTemplate.findAll(this.entityType);
    }

    public Iterable<T> findAllById(Iterable<ID> ids) {
        return this.datastoreTemplate.findAllById(ids, this.entityType);
    }

    public long count() {
        return this.datastoreTemplate.count(this.entityType);
    }

    public void deleteById(ID id) {
        this.datastoreTemplate.deleteById(id, this.entityType);
    }

    public void delete(T entity) {
        this.datastoreTemplate.delete(entity);
    }

    public void deleteAll(Iterable<? extends T> entities) {
        this.datastoreTemplate.deleteAll(entities);
    }

    public void deleteAll() {
        this.datastoreTemplate.deleteAll(this.entityType);
    }
}

