/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.datastore.core;

import com.google.cloud.datastore.Cursor;
import java.util.Objects;
import org.springframework.data.domain.Sort;

public final class DatastoreQueryOptions {
    private Integer limit;
    private Integer offset;
    private Sort sort;
    private Cursor cursor;

    private DatastoreQueryOptions(Integer limit, Integer offset, Sort sort, Cursor cursor) {
        this.limit = limit;
        this.offset = offset;
        this.sort = sort;
        this.cursor = cursor;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public Sort getSort() {
        return this.sort;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatastoreQueryOptions that = (DatastoreQueryOptions)o;
        return Objects.equals(this.getLimit(), that.getLimit()) && Objects.equals(this.getOffset(), that.getOffset()) && Objects.equals(this.getSort(), that.getSort()) && Objects.equals(this.getCursor(), that.getCursor());
    }

    public int hashCode() {
        return Objects.hash(this.getLimit(), this.getOffset(), this.getSort(), this.getCursor());
    }

    public static class Builder {
        private Integer limit;
        private Integer offset;
        private Sort sort;
        private Cursor cursor;

        public Builder setLimit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder setOffset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public Builder setSort(Sort sort) {
            this.sort = sort;
            return this;
        }

        public Builder setCursor(Cursor cursor) {
            this.cursor = cursor;
            return this;
        }

        public DatastoreQueryOptions build() {
            return new DatastoreQueryOptions(this.limit, this.offset, this.sort, this.cursor);
        }
    }
}

