/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.core.admin;

import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerDataException;
import org.springframework.util.Assert;

public class SpannerDatabaseAdminTemplate {
    private static final String TABLE_NAME_COL_NAME = "table_name";
    private static final String PARENT_TABLE_NAME_COL_NAME = "parent_table_name";
    private static final Statement TABLE_AND_PARENT_QUERY = Statement.of((String)"SELECT t.table_name, t.parent_table_name FROM information_schema.tables AS t");
    private final DatabaseAdminClient databaseAdminClient;
    private final DatabaseId databaseId;
    private final DatabaseClient databaseClient;

    public SpannerDatabaseAdminTemplate(DatabaseAdminClient databaseAdminClient, DatabaseClient databaseClient, DatabaseId databaseId) {
        Assert.notNull((Object)databaseAdminClient, (String)"A valid database admin client is required.");
        Assert.notNull((Object)databaseId, (String)"A valid database ID is required.");
        Assert.notNull((Object)databaseClient, (String)"A valid database client is required.");
        this.databaseAdminClient = databaseAdminClient;
        this.databaseId = databaseId;
        this.databaseClient = databaseClient;
    }

    public void executeDdlStrings(Iterable<String> ddlStrings, boolean createDatabase) {
        try {
            if (createDatabase && !this.databaseExists()) {
                this.databaseAdminClient.createDatabase(this.getInstanceId(), this.getDatabase(), ddlStrings).get();
            } else {
                this.databaseAdminClient.updateDatabaseDdl(this.getInstanceId(), this.getDatabase(), ddlStrings, null).get();
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new SpannerDataException("DDL execution was interrupted", ex);
        }
        catch (ExecutionException ex) {
            throw new SpannerDataException("DDL could not be executed", ex);
        }
    }

    public String getInstanceId() {
        return this.databaseId.getInstanceId().getInstance();
    }

    public String getDatabase() {
        return this.databaseId.getDatabase();
    }

    public boolean databaseExists() {
        for (Database db : this.databaseAdminClient.listDatabases(this.getInstanceId(), new Options.ListOption[0]).getValues()) {
            if (!this.getDatabase().equals(db.getId().getDatabase())) continue;
            return true;
        }
        return false;
    }

    public Map<String, String> getChildParentTablesMap() {
        HashMap<String, String> relationships = new HashMap<String, String>();
        ResultSet results = this.databaseClient.singleUse().executeQuery(TABLE_AND_PARENT_QUERY, new Options.QueryOption[0]);
        while (results.next()) {
            Struct row = results.getCurrentRowAsStruct();
            relationships.put(row.getString(TABLE_NAME_COL_NAME), row.isNull(PARENT_TABLE_NAME_COL_NAME) ? null : row.getString(PARENT_TABLE_NAME_COL_NAME));
        }
        results.close();
        return relationships;
    }

    public boolean isInterleaved(String ancestor, String descendant) {
        Assert.notNull((Object)ancestor, (String)"A non-null ancestor table name is required.");
        Set<String> directChildren = this.getParentChildTablesMap().get(ancestor);
        if (ancestor.equals(descendant) || directChildren == null) {
            return false;
        }
        for (String child : directChildren) {
            if (!child.equals(descendant) && !this.isInterleaved(child, descendant)) continue;
            return true;
        }
        return false;
    }

    public Map<String, Set<String>> getParentChildTablesMap() {
        HashMap<String, Set<String>> relationships = new HashMap<String, Set<String>>();
        Map<String, String> childToParent = this.getChildParentTablesMap();
        for (String child : childToParent.keySet()) {
            if (childToParent.get(child) == null) continue;
            String parent = childToParent.get(child);
            HashSet<String> children = (HashSet<String>)relationships.get(parent);
            if (children == null) {
                children = new HashSet<String>();
                relationships.put(parent, children);
            }
            children.add(child);
        }
        return relationships;
    }

    public Set<String> getTables() {
        return this.getChildParentTablesMap().keySet();
    }

    public boolean tableExists(String table) {
        return this.databaseExists() && this.getTables().contains(table);
    }
}

