/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.pubsub.integration.inbound;

import org.springframework.cloud.gcp.pubsub.integration.AckMode;
import org.springframework.cloud.gcp.pubsub.support.AcknowledgeablePubsubMessage;
import org.springframework.integration.acks.AcknowledgmentCallback;
import org.springframework.util.Assert;

public class PubSubAcknowledgmentCallback
implements AcknowledgmentCallback {
    private final AcknowledgeablePubsubMessage message;
    private final AckMode ackMode;
    private boolean acknowledged;

    public PubSubAcknowledgmentCallback(AcknowledgeablePubsubMessage message, AckMode ackMode) {
        Assert.notNull((Object)message, (String)"message to be acknowledged cannot be null");
        Assert.notNull((Object)((Object)ackMode), (String)"ackMode cannot be null");
        this.message = message;
        this.ackMode = ackMode;
    }

    public void acknowledge(AcknowledgmentCallback.Status status) {
        if (status == AcknowledgmentCallback.Status.ACCEPT) {
            this.message.ack();
        } else if (this.ackMode == AckMode.MANUAL || this.ackMode == AckMode.AUTO) {
            this.message.nack();
        }
        this.acknowledged = true;
    }

    public boolean isAutoAck() {
        return this.ackMode != AckMode.MANUAL;
    }

    public boolean isAcknowledged() {
        return this.acknowledged;
    }
}

