/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Pod;
import java.io.IOException;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.info.ConditionalOnEnabledInfoContributor;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.kubernetes.client.KubernetesClientHealthIndicator;
import org.springframework.cloud.kubernetes.client.KubernetesClientInfoContributor;
import org.springframework.cloud.kubernetes.client.KubernetesClientPodUtils;
import org.springframework.cloud.kubernetes.client.KubernetesClientUtils;
import org.springframework.cloud.kubernetes.commons.ConditionalOnKubernetesEnabled;
import org.springframework.cloud.kubernetes.commons.KubernetesClientProperties;
import org.springframework.cloud.kubernetes.commons.KubernetesCommonsAutoConfiguration;
import org.springframework.cloud.kubernetes.commons.PodUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnKubernetesEnabled
@AutoConfigureAfter(value={KubernetesCommonsAutoConfiguration.class})
public class KubernetesClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ApiClient apiClient() throws IOException {
        ApiClient apiClient = KubernetesClientUtils.kubernetesApiClient();
        io.kubernetes.client.openapi.Configuration.setDefaultApiClient((ApiClient)apiClient);
        return apiClient;
    }

    @Bean
    @ConditionalOnMissingBean
    public CoreV1Api coreApi(ApiClient apiClient) throws IOException {
        return new CoreV1Api(apiClient);
    }

    @Bean
    @ConditionalOnMissingBean
    public KubernetesClientPodUtils kubernetesPodUtils(CoreV1Api client, KubernetesClientProperties kubernetesClientProperties) {
        return new KubernetesClientPodUtils(client, kubernetesClientProperties.getNamespace());
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HealthIndicator.class})
    protected static class KubernetesActuatorConfiguration {
        protected KubernetesActuatorConfiguration() {
        }

        @Bean
        @ConditionalOnEnabledHealthIndicator(value="kubernetes")
        public KubernetesClientHealthIndicator kubernetesHealthIndicator(PodUtils podUtils) {
            return new KubernetesClientHealthIndicator((PodUtils<V1Pod>)podUtils);
        }

        @Bean
        @ConditionalOnEnabledInfoContributor(value="kubernetes")
        public KubernetesClientInfoContributor kubernetesInfoContributor(PodUtils podUtils) {
            return new KubernetesClientInfoContributor((PodUtils<V1Pod>)podUtils);
        }
    }
}

