/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.util.ClientBuilder;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class KubernetesClientUtils {
    private static final Log LOG = LogFactory.getLog(KubernetesClientUtils.class);

    private KubernetesClientUtils() {
    }

    public static ApiClient kubernetesApiClient() throws IOException {
        try {
            ApiClient apiClient = ClientBuilder.cluster().build();
            LOG.info((Object)"Created API client in the cluster.");
            return apiClient;
        }
        catch (Exception e) {
            LOG.info((Object)"Could not create the Kubernetes ApiClient in a cluster environment, trying to use a \"standard\" configuration instead.", (Throwable)e);
            try {
                ApiClient apiClient = ClientBuilder.standard().build();
                return apiClient;
            }
            catch (Exception e1) {
                LOG.warn((Object)"Could not create a Kubernetes ApiClient from either a cluster or standard environment", (Throwable)e1);
                return new ClientBuilder().build();
            }
        }
    }
}

