/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.config;

import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Secret;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.config.SecretsPropertySource;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class KubernetesClientSecretsPropertySource
extends SecretsPropertySource {
    private static final Log LOG = LogFactory.getLog(KubernetesClientSecretsPropertySource.class);
    private CoreV1Api coreV1Api;

    public KubernetesClientSecretsPropertySource(CoreV1Api coreV1Api, String name, String namespace, Environment environment, Map<String, String> labels) {
        super(KubernetesClientSecretsPropertySource.getSourceName((String)name, (String)namespace), KubernetesClientSecretsPropertySource.getSourceData(coreV1Api, environment, name, namespace, labels));
    }

    private static Map<String, Object> getSourceData(CoreV1Api api, Environment env, String name, String namespace, Map<String, String> labels) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            if (StringUtils.hasText((String)name)) {
                Optional<V1Secret> secret = !StringUtils.hasText((String)namespace) ? api.listSecretForAllNamespaces(null, null, null, null, null, null, null, null, null).getItems().stream().filter(s -> name.equals(s.getMetadata().getName())).findFirst() : api.listNamespacedSecret(namespace, null, null, null, null, null, null, null, null, null).getItems().stream().filter(s -> name.equals(s.getMetadata().getName())).findFirst();
                secret.ifPresent(s -> KubernetesClientSecretsPropertySource.putAll(s, result));
            }
            if (labels != null && !labels.isEmpty()) {
                if (!StringUtils.hasText((String)namespace)) {
                    api.listSecretForAllNamespaces(null, null, null, KubernetesClientSecretsPropertySource.createLabelsSelector(labels), null, null, null, null, null).getItems().forEach(s -> KubernetesClientSecretsPropertySource.putAll(s, result));
                } else {
                    api.listNamespacedSecret(namespace, null, null, null, null, KubernetesClientSecretsPropertySource.createLabelsSelector(labels), null, null, null, null).getItems().forEach(s -> KubernetesClientSecretsPropertySource.putAll(s, result));
                }
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Can't read secret with name: [" + name + "] or labels [" + labels + "] in namespace:[" + namespace + "] (cause: " + e.getMessage() + "). Ignoring"), (Throwable)e);
        }
        return result;
    }

    private static String createLabelsSelector(Map<String, String> labels) {
        StringBuilder selectorString = new StringBuilder();
        for (String key : labels.keySet()) {
            if (selectorString.length() != 0) {
                selectorString.append(",");
            }
            selectorString.append(key + "=" + labels.get(key));
        }
        return selectorString.toString();
    }

    private static void putAll(V1Secret secret, Map<String, Object> result) {
        HashMap secretData = new HashMap();
        secret.getData().forEach((key, value) -> secretData.put(key, Base64.getEncoder().encodeToString((byte[])value)));
        if (secret != null) {
            KubernetesClientSecretsPropertySource.putAll(secretData, result);
        }
    }
}

