/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.config;

import io.kubernetes.client.openapi.apis.CoreV1Api;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.cloud.kubernetes.client.KubernetesClientAutoConfiguration;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientBootstrapConfiguration;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientSecretsPropertySourceLocator;
import org.springframework.cloud.kubernetes.client.config.RetryableKubernetesClientConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.client.config.RetryableKubernetesClientSecretsPropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.KubernetesCommonsAutoConfiguration;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.ConditionalOnKubernetesConfigOrSecretsRetryEnabled;
import org.springframework.cloud.kubernetes.commons.config.ConditionalOnKubernetesConfigRetryEnabled;
import org.springframework.cloud.kubernetes.commons.config.ConditionalOnKubernetesSecretsRetryEnabled;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.KubernetesBootstrapConfiguration;
import org.springframework.cloud.kubernetes.commons.config.SecretsConfigProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={KubernetesBootstrapConfiguration.class})
@AutoConfigureBefore(value={KubernetesClientBootstrapConfiguration.class})
@Import(value={KubernetesCommonsAutoConfiguration.class, KubernetesClientAutoConfiguration.class})
@ConditionalOnKubernetesConfigOrSecretsRetryEnabled
@ConditionalOnCloudPlatform(value=CloudPlatform.KUBERNETES)
public class KubernetesClientRetryBootstrapConfiguration {
    @Bean
    @ConditionalOnKubernetesConfigRetryEnabled
    public KubernetesClientConfigMapPropertySourceLocator retryableConfigMapPropertySourceLocator(ConfigMapConfigProperties properties, CoreV1Api coreV1Api, KubernetesNamespaceProvider kubernetesNamespaceProvider) {
        return new RetryableKubernetesClientConfigMapPropertySourceLocator(coreV1Api, properties, kubernetesNamespaceProvider);
    }

    @Bean
    @ConditionalOnKubernetesSecretsRetryEnabled
    public KubernetesClientSecretsPropertySourceLocator retryableSecretsPropertySourceLocator(SecretsConfigProperties properties, CoreV1Api coreV1Api, KubernetesNamespaceProvider kubernetesNamespaceProvider) {
        return new RetryableKubernetesClientSecretsPropertySourceLocator(coreV1Api, kubernetesNamespaceProvider, properties);
    }
}

