/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.discovery;

import io.kubernetes.client.extended.wait.Wait;
import io.kubernetes.client.informer.SharedInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.openapi.models.V1EndpointPort;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1Service;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesServiceInstance;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class KubernetesInformerDiscoveryClient
implements DiscoveryClient,
InitializingBean {
    private static final Log log = LogFactory.getLog(KubernetesInformerDiscoveryClient.class);
    private final SharedInformerFactory sharedInformerFactory;
    private final Lister<V1Service> serviceLister;
    private final Supplier<Boolean> informersReadyFunc;
    private final Lister<V1Endpoints> endpointsLister;
    private final KubernetesDiscoveryProperties properties;
    private final String namespace;

    public KubernetesInformerDiscoveryClient(String namespace, SharedInformerFactory sharedInformerFactory, Lister<V1Service> serviceLister, Lister<V1Endpoints> endpointsLister, SharedInformer<V1Service> serviceInformer, SharedInformer<V1Endpoints> endpointsInformer, KubernetesDiscoveryProperties properties) {
        this.namespace = namespace;
        this.sharedInformerFactory = sharedInformerFactory;
        this.serviceLister = serviceLister;
        this.endpointsLister = endpointsLister;
        this.informersReadyFunc = () -> serviceInformer.hasSynced() && endpointsInformer.hasSynced();
        this.properties = properties;
    }

    public String description() {
        return "Kubernetes Client Discovery";
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        V1Endpoints ep;
        V1Service service;
        Assert.notNull((Object)serviceId, (String)"[Assertion failed] - the object argument must not be null");
        if (StringUtils.hasText((String)this.namespace) && !this.properties.isAllNamespaces()) {
            log.warn((Object)"Namespace is null or empty, this may cause issues looking up services");
        }
        V1Service v1Service = service = this.properties.isAllNamespaces() ? (V1Service)this.serviceLister.list().stream().filter(svc -> serviceId.equals(svc.getMetadata().getName())).findFirst().orElse(null) : (V1Service)this.serviceLister.namespace(this.namespace).get(serviceId);
        if (service == null) {
            return new ArrayList<ServiceInstance>();
        }
        HashMap svcMetadata = new HashMap();
        if (this.properties.getMetadata() != null) {
            if (this.properties.getMetadata().isAddLabels() && service.getMetadata().getLabels() != null) {
                String labelPrefix = this.properties.getMetadata().getLabelsPrefix() != null ? this.properties.getMetadata().getLabelsPrefix() : "";
                service.getMetadata().getLabels().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(labelPrefix)).forEach(e -> {
                    String cfr_ignored_0 = (String)svcMetadata.put(e.getKey(), e.getValue());
                });
            }
            if (this.properties.getMetadata().isAddAnnotations() && service.getMetadata().getAnnotations() != null) {
                String annotationPrefix = this.properties.getMetadata().getAnnotationsPrefix() != null ? this.properties.getMetadata().getAnnotationsPrefix() : "";
                service.getMetadata().getAnnotations().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(annotationPrefix)).forEach(e -> {
                    String cfr_ignored_0 = (String)svcMetadata.put(e.getKey(), e.getValue());
                });
            }
        }
        if ((ep = (V1Endpoints)this.endpointsLister.namespace(service.getMetadata().getNamespace()).get(service.getMetadata().getName())) == null) {
            return new ArrayList<ServiceInstance>();
        }
        return ep.getSubsets().stream().flatMap(subset -> {
            HashMap metadata = new HashMap(svcMetadata);
            if (this.properties.getMetadata() != null && this.properties.getMetadata().isAddPorts()) {
                subset.getPorts().stream().forEach(p -> metadata.put(p.getName(), Integer.toString(p.getPort())));
            }
            V1EndpointPort port = subset.getPorts() != null && subset.getPorts().size() == 1 ? (V1EndpointPort)subset.getPorts().get(0) : subset.getPorts().stream().filter(p -> this.properties.getPrimaryPortName().equalsIgnoreCase(p.getName())).findFirst().orElseThrow(IllegalStateException::new);
            return subset.getAddresses().stream().map(addr -> new KubernetesServiceInstance(addr.getTargetRef() != null ? addr.getTargetRef().getUid() : "", serviceId, addr.getIp(), port.getPort().intValue(), metadata, Boolean.valueOf(false)));
        }).collect(Collectors.toList());
    }

    public List<String> getServices() {
        List services = this.properties.isAllNamespaces() ? this.serviceLister.list() : this.serviceLister.namespace(this.namespace).list();
        return services.stream().map(s -> s.getMetadata().getName()).collect(Collectors.toList());
    }

    public void afterPropertiesSet() throws Exception {
        this.sharedInformerFactory.startAllRegisteredInformers();
        if (!Wait.poll((Duration)Duration.ofSeconds(1L), (Duration)Duration.ofSeconds(this.properties.getCacheLoadingTimeoutSeconds()), () -> {
            log.info((Object)"Waiting for the cache of informers to be fully loaded..");
            return this.informersReadyFunc.get();
        })) {
            if (this.properties.isWaitCacheReady()) {
                throw new IllegalStateException("Timeout waiting for informers cache to be ready, is the kubernetes service up?");
            }
            log.warn((Object)"Timeout waiting for informers cache to be ready, ignoring the failure because waitForInformerCacheReady property is false");
        }
        log.info((Object)("Cache fully loaded (total " + this.serviceLister.list().size() + " services) , discovery client is now available"));
    }
}

