/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.discovery;

import io.kubernetes.client.informer.SharedIndexInformer;
import io.kubernetes.client.informer.SharedInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.spring.extended.controller.KubernetesInformerFactoryProcessor;
import io.kubernetes.client.spring.extended.controller.annotation.KubernetesInformer;
import io.kubernetes.client.spring.extended.controller.annotation.KubernetesInformers;
import io.kubernetes.client.util.generic.GenericKubernetesApi;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.core.ResolvableType;

class SpringCloudKubernetesInformerFactoryProcessor
extends KubernetesInformerFactoryProcessor {
    private static final Logger log = LoggerFactory.getLogger(SpringCloudKubernetesInformerFactoryProcessor.class);
    private BeanDefinitionRegistry beanDefinitionRegistry;
    private final ApiClient apiClient;
    private final SharedInformerFactory sharedInformerFactory;
    private final boolean allNamespaces;
    private final KubernetesNamespaceProvider kubernetesNamespaceProvider;

    @Autowired
    SpringCloudKubernetesInformerFactoryProcessor(KubernetesNamespaceProvider kubernetesNamespaceProvider, ApiClient apiClient, SharedInformerFactory sharedInformerFactory, boolean allNamespaces) {
        this.apiClient = apiClient;
        this.sharedInformerFactory = sharedInformerFactory;
        this.kubernetesNamespaceProvider = kubernetesNamespaceProvider;
        this.allNamespaces = allNamespaces;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String namespace = this.allNamespaces ? "" : (this.kubernetesNamespaceProvider.getNamespace() == null ? "default" : this.kubernetesNamespaceProvider.getNamespace());
        this.apiClient.setHttpClient(this.apiClient.getHttpClient().newBuilder().readTimeout(Duration.ZERO).build());
        KubernetesInformers kubernetesInformers = this.sharedInformerFactory.getClass().getAnnotation(KubernetesInformers.class);
        if (kubernetesInformers == null || kubernetesInformers.value().length == 0) {
            log.info("No informers registered in the sharedInformerFactory..");
            return;
        }
        for (KubernetesInformer kubernetesInformer : kubernetesInformers.value()) {
            GenericKubernetesApi api = new GenericKubernetesApi(kubernetesInformer.apiTypeClass(), kubernetesInformer.apiListTypeClass(), kubernetesInformer.groupVersionResource().apiGroup(), kubernetesInformer.groupVersionResource().apiVersion(), kubernetesInformer.groupVersionResource().resourcePlural(), this.apiClient);
            SharedIndexInformer sharedIndexInformer = this.sharedInformerFactory.sharedIndexInformerFor(api, kubernetesInformer.apiTypeClass(), kubernetesInformer.resyncPeriodMillis(), kubernetesInformer.namespace().equals("") ? namespace : kubernetesInformer.namespace());
            ResolvableType informerType = ResolvableType.forClassWithGenerics(SharedInformer.class, (Class[])new Class[]{kubernetesInformer.apiTypeClass()});
            RootBeanDefinition informerBean = new RootBeanDefinition();
            informerBean.setTargetType(informerType);
            informerBean.setAutowireMode(2);
            informerBean.setAutowireCandidate(true);
            String informerBeanName = informerType.toString();
            this.beanDefinitionRegistry.registerBeanDefinition(informerBeanName, (BeanDefinition)informerBean);
            beanFactory.registerSingleton(informerBeanName, (Object)sharedIndexInformer);
            Lister lister = new Lister(sharedIndexInformer.getIndexer());
            ResolvableType listerType = ResolvableType.forClassWithGenerics(Lister.class, (Class[])new Class[]{kubernetesInformer.apiTypeClass()});
            RootBeanDefinition listerBean = new RootBeanDefinition();
            listerBean.setTargetType(listerType);
            listerBean.setAutowireMode(2);
            listerBean.setAutowireCandidate(true);
            String listerBeanName = listerType.toString();
            this.beanDefinitionRegistry.registerBeanDefinition(listerBeanName, (BeanDefinition)listerBean);
            beanFactory.registerSingleton(listerBeanName, (Object)lister);
        }
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        this.beanDefinitionRegistry = registry;
    }
}

