/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.discovery;

import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.discovery.PodLabelsAndAnnotations;
import org.springframework.core.log.LogAccessor;

final class K8sPodLabelsAndAnnotationsSupplier
implements Function<String, PodLabelsAndAnnotations> {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(K8sPodLabelsAndAnnotationsSupplier.class));
    private final CoreV1Api coreV1Api;
    private final String namespace;

    private K8sPodLabelsAndAnnotationsSupplier(CoreV1Api coreV1Api, String namespace) {
        this.coreV1Api = coreV1Api;
        this.namespace = namespace;
    }

    static K8sPodLabelsAndAnnotationsSupplier nonExternalName(CoreV1Api coreV1Api, String namespace) {
        return new K8sPodLabelsAndAnnotationsSupplier(coreV1Api, namespace);
    }

    static K8sPodLabelsAndAnnotationsSupplier externalName() {
        return new K8sPodLabelsAndAnnotationsSupplier(null, null);
    }

    @Override
    public PodLabelsAndAnnotations apply(String podName) {
        V1ObjectMeta objectMeta;
        try {
            objectMeta = Optional.ofNullable(this.coreV1Api.readNamespacedPod(podName, this.namespace, null).getMetadata()).orElse(((V1ObjectMetaBuilder)((V1ObjectMetaBuilder)new V1ObjectMetaBuilder().withLabels(Map.of())).withAnnotations(Map.of())).build());
        }
        catch (ApiException e) {
            LOG.warn((Throwable)e, (CharSequence)"Could not get pod metadata");
            objectMeta = ((V1ObjectMetaBuilder)((V1ObjectMetaBuilder)new V1ObjectMetaBuilder().withLabels(Map.of())).withAnnotations(Map.of())).build();
        }
        return new PodLabelsAndAnnotations(Optional.ofNullable(objectMeta.getLabels()).orElse(Map.of()), Optional.ofNullable(objectMeta.getAnnotations()).orElse(Map.of()));
    }
}

