/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.loadbalancer;

import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Service;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.commons.loadbalancer.KubernetesServiceInstanceMapper;
import org.springframework.cloud.kubernetes.commons.loadbalancer.KubernetesServicesListSupplier;
import org.springframework.core.env.Environment;
import reactor.core.publisher.Flux;

public class KubernetesClientServicesListSupplier
extends KubernetesServicesListSupplier<V1Service> {
    private static final Log LOG = LogFactory.getLog(KubernetesClientServicesListSupplier.class);
    private final CoreV1Api coreV1Api;
    private final String namespace;

    public KubernetesClientServicesListSupplier(Environment environment, KubernetesServiceInstanceMapper<V1Service> mapper, KubernetesDiscoveryProperties discoveryProperties, CoreV1Api coreV1Api, KubernetesNamespaceProvider kubernetesNamespaceProvider) {
        super(environment, mapper, discoveryProperties);
        this.coreV1Api = coreV1Api;
        this.namespace = kubernetesNamespaceProvider.getNamespace();
    }

    public Flux<List<ServiceInstance>> get() {
        LOG.info((Object)("Getting services with id " + this.getServiceId()));
        ArrayList result = new ArrayList();
        try {
            List services = this.discoveryProperties.allNamespaces() ? this.coreV1Api.listServiceForAllNamespaces(null, null, "metadata.name=" + this.getServiceId(), null, null, null, null, null, null, null, null).getItems() : this.coreV1Api.listNamespacedService(this.namespace, null, null, null, "metadata.name=" + this.getServiceId(), null, null, null, null, null, null, null).getItems();
            services.forEach(service -> result.add(this.mapper.map(service)));
        }
        catch (ApiException e) {
            LOG.warn((Object)("Error retrieving service with name " + this.getServiceId()), (Throwable)e);
        }
        LOG.info((Object)("Returning services: " + result));
        return Flux.defer(() -> Flux.just((Object)result));
    }
}

