/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config.reload;

import java.util.Objects;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadProperties;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationUpdateStrategy;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.log.LogAccessor;

public abstract class ConfigurationChangeDetector {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(ConfigurationChangeDetector.class));
    protected ConfigurableEnvironment environment;
    protected ConfigReloadProperties properties;
    protected ConfigurationUpdateStrategy strategy;

    public ConfigurationChangeDetector(ConfigurableEnvironment environment, ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy) {
        this.environment = Objects.requireNonNull(environment);
        this.properties = Objects.requireNonNull(properties);
        this.strategy = Objects.requireNonNull(strategy);
    }

    public void reloadProperties() {
        LOG.info(() -> "Reloading using strategy: " + this.strategy.name());
        this.strategy.reloadProcedure().run();
    }
}

