/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.cloud.kubernetes.commons.config.MultipleSourcesContainer;
import org.springframework.cloud.kubernetes.commons.config.PrefixContext;
import org.springframework.cloud.kubernetes.commons.config.SourceData;
import org.springframework.cloud.kubernetes.commons.config.SourceDataEntriesProcessor;
import org.springframework.cloud.kubernetes.commons.config.StrippedSourceContainer;
import org.springframework.core.env.Environment;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public final class ConfigUtils {
    private static final Log LOG = LogFactory.getLog(ConfigUtils.class);
    private static final BiPredicate<String, String> ENDS_WITH_PROFILE_AND_EXTENSION = (sourceName, activeProfile) -> sourceName.endsWith("-" + activeProfile + ".yml") || sourceName.endsWith("-" + activeProfile + ".yaml") || sourceName.endsWith("-" + activeProfile + ".properties");

    private ConfigUtils() {
    }

    public static String getApplicationName(Environment env, String configName, String configurationTarget) {
        if (!StringUtils.hasLength((String)configName)) {
            LOG.debug((Object)(configurationTarget + " name has not been set, taking it from property/env spring.application.name (default=application)"));
            configName = env.getProperty("spring.application.name", "application");
        }
        return configName;
    }

    public static Prefix findPrefix(String explicitPrefix, Boolean useNameAsPrefix, boolean defaultUseNameAsPrefix, String normalizedName) {
        if (StringUtils.hasText((String)explicitPrefix)) {
            Prefix.computeKnown(() -> explicitPrefix);
            return Prefix.KNOWN;
        }
        if (useNameAsPrefix != null) {
            if (useNameAsPrefix.booleanValue()) {
                if (normalizedName == null) {
                    return Prefix.DELAYED;
                }
                Prefix.computeKnown(() -> normalizedName);
                return Prefix.KNOWN;
            }
            return Prefix.DEFAULT;
        }
        if (defaultUseNameAsPrefix) {
            if (normalizedName == null) {
                return Prefix.DELAYED;
            }
            Prefix.computeKnown(() -> normalizedName);
            return Prefix.KNOWN;
        }
        return Prefix.DEFAULT;
    }

    public static boolean includeProfileSpecificSources(boolean defaultIncludeProfileSpecificSources, Boolean includeProfileSpecificSources) {
        if (includeProfileSpecificSources != null) {
            return includeProfileSpecificSources;
        }
        return defaultIncludeProfileSpecificSources;
    }

    public static void onException(boolean failFast, Exception e) {
        if (failFast) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        LOG.warn((Object)(e.getMessage() + ". Ignoring."), (Throwable)e);
    }

    public static SourceData withPrefix(String target, PrefixContext context) {
        HashMap withPrefix = CollectionUtils.newHashMap((int)context.data().size());
        context.data().forEach((key, value) -> withPrefix.put(context.prefix() + "." + key, value));
        String propertySourceTokens = String.join((CharSequence)".", context.propertySourceNames().stream().sorted().collect(Collectors.toCollection(LinkedHashSet::new)));
        return new SourceData(ConfigUtils.sourceName(target, propertySourceTokens, context.namespace()), withPrefix);
    }

    public static String sourceName(String target, String applicationName, String namespace) {
        return target + "." + applicationName + "." + namespace;
    }

    public static String sourceName(String target, String applicationName, String namespace, String[] profiles) {
        Object name = ConfigUtils.sourceName(target, applicationName, namespace);
        if (profiles != null && profiles.length > 0) {
            name = (String)name + "." + StringUtils.arrayToDelimitedString((Object[])profiles, (String)"-");
        }
        return name;
    }

    public static MultipleSourcesContainer processNamedData(List<StrippedSourceContainer> strippedSources, Environment environment, LinkedHashSet<String> sourceNames, String namespace, boolean decode) {
        return ConfigUtils.processNamedData(strippedSources, environment, sourceNames, namespace, decode, true);
    }

    public static MultipleSourcesContainer processNamedData(List<StrippedSourceContainer> strippedSources, Environment environment, LinkedHashSet<String> sourceNames, String namespace, boolean decode, boolean includeDefaultProfileData) {
        Map hashByName = strippedSources.stream().collect(Collectors.toMap(StrippedSourceContainer::name, Function.identity()));
        LinkedHashSet<String> foundSourceNames = new LinkedHashSet<String>();
        HashMap<String, Object> data = new HashMap<String, Object>();
        sourceNames.forEach(sourceName -> {
            StrippedSourceContainer stripped = (StrippedSourceContainer)hashByName.get(sourceName);
            if (stripped != null) {
                LOG.debug((Object)("Found source with name : '" + sourceName + " in namespace: '" + namespace + "'"));
                foundSourceNames.add((String)sourceName);
                Map<String, String> rawData = stripped.data();
                if (decode) {
                    rawData = ConfigUtils.decodeData(rawData);
                }
                if (ConfigUtils.processSource(includeDefaultProfileData, environment, sourceName, rawData)) {
                    data.putAll(SourceDataEntriesProcessor.processAllEntries(rawData == null ? Map.of() : rawData, environment, includeDefaultProfileData));
                }
            }
        });
        return new MultipleSourcesContainer(foundSourceNames, data);
    }

    static boolean processSource(boolean includeDefaultProfileData, Environment environment, String sourceName, Map<String, String> sourceRawData) {
        List<String> activeProfiles = Arrays.stream(environment.getActiveProfiles()).toList();
        boolean emptyActiveProfiles = activeProfiles.isEmpty();
        boolean profileBasedSourceName = activeProfiles.stream().anyMatch(activeProfile -> sourceName.endsWith("-" + activeProfile));
        boolean defaultProfilePresent = activeProfiles.contains("default");
        return includeDefaultProfileData || emptyActiveProfiles || profileBasedSourceName || defaultProfilePresent || ConfigUtils.rawDataContainsProfileBasedSource(activeProfiles, sourceRawData).getAsBoolean();
    }

    static BooleanSupplier rawDataContainsProfileBasedSource(List<String> activeProfiles, Map<String, String> sourceRawData) {
        return () -> Optional.ofNullable(sourceRawData).orElse(Map.of()).keySet().stream().anyMatch(keyName -> activeProfiles.stream().anyMatch(activeProfile -> ENDS_WITH_PROFILE_AND_EXTENSION.test((String)keyName, (String)activeProfile)));
    }

    public static MultipleSourcesContainer processLabeledData(List<StrippedSourceContainer> containers, Environment environment, Map<String, String> labels, String namespace, Set<String> profiles, boolean decode) {
        List<StrippedSourceContainer> byLabels = containers.stream().filter(one -> {
            Map<String, String> sourceLabels = one.labels();
            Map<Object, Object> labelsToSearchAgainst = sourceLabels == null ? Map.of() : sourceLabels;
            return labelsToSearchAgainst.entrySet().containsAll(labels.entrySet());
        }).toList();
        ArrayList<CallSite> sourceNamesByLabelsWithProfile = new ArrayList<CallSite>();
        if (profiles != null && !profiles.isEmpty()) {
            for (StrippedSourceContainer one2 : byLabels) {
                for (String profile : profiles) {
                    String name = one2.name() + "-" + profile;
                    sourceNamesByLabelsWithProfile.add((CallSite)((Object)name));
                }
            }
        }
        List<StrippedSourceContainer> byProfile = containers.stream().filter(one -> sourceNamesByLabelsWithProfile.contains(one.name())).toList();
        ArrayList<StrippedSourceContainer> all = new ArrayList<StrippedSourceContainer>(byLabels.size() + byProfile.size());
        all.addAll(byLabels);
        all.addAll(byProfile);
        LinkedHashSet<String> sourceNames = new LinkedHashSet<String>();
        HashMap<String, Object> result = new HashMap<String, Object>();
        all.forEach(source -> {
            String foundSourceName = source.name();
            LOG.debug((Object)("Loaded source with name : '" + foundSourceName + " in namespace: '" + namespace + "'"));
            sourceNames.add(foundSourceName);
            Map<String, String> rawData = source.data();
            if (decode) {
                rawData = ConfigUtils.decodeData(rawData);
            }
            result.putAll(SourceDataEntriesProcessor.processAllEntries(rawData, environment));
        });
        return new MultipleSourcesContainer(sourceNames, result);
    }

    private static Map<String, String> decodeData(Map<String, String> data) {
        HashMap<String, String> result = new HashMap<String, String>(CollectionUtils.newHashMap((int)data.size()));
        data.forEach((key, value) -> result.put((String)key, new String(Base64.getDecoder().decode((String)value)).trim()));
        return result;
    }

    public static <T> void registerSingle(ConfigurableBootstrapContext bootstrapContext, Class<T> cls, T instance, String name) {
        bootstrapContext.registerIfAbsent(cls, BootstrapRegistry.InstanceSupplier.of(instance));
        bootstrapContext.addCloseListener(event -> {
            if (event.getApplicationContext().getBeanFactory().getSingleton(name) == null) {
                event.getApplicationContext().getBeanFactory().registerSingleton(name, event.getBootstrapContext().get(cls));
            }
        });
    }

    public static Map<String, String> keysWithPrefix(Map<String, String> map, String prefix) {
        if (map == null || map.isEmpty()) {
            return Map.of();
        }
        if (!StringUtils.hasText((String)prefix)) {
            return map;
        }
        HashMap result = CollectionUtils.newHashMap((int)map.size());
        map.forEach((key, value) -> result.put(prefix + key, value));
        return result;
    }

    public static final class Prefix {
        public static final Prefix DEFAULT = new Prefix(() -> "", "DEFAULT");
        public static final Prefix DELAYED = new Prefix(() -> {
            throw new IllegalArgumentException("prefix is delayed, needs to be taken elsewhere");
        }, "DELAYED");
        public static Prefix KNOWN;
        private final Supplier<String> prefixProvider;
        private final String name;

        public Supplier<String> prefixProvider() {
            return this.prefixProvider;
        }

        private Prefix(Supplier<String> prefixProvider, String name) {
            this.prefixProvider = prefixProvider;
            this.name = name;
        }

        private static void computeKnown(Supplier<String> supplier) {
            KNOWN = new Prefix(supplier, "KNOWN");
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("name", (Object)this.name).toString();
        }
    }
}

