/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.config;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.config.PropertySourceUtils;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.StringUtils;

public class ConfigMapPropertySource
extends MapPropertySource {
    private static final Log LOG = LogFactory.getLog(ConfigMapPropertySource.class);
    private static final String APPLICATION_YML = "application.yml";
    private static final String APPLICATION_YAML = "application.yaml";
    private static final String APPLICATION_PROPERTIES = "application.properties";
    private static final String PREFIX = "configmap";

    public ConfigMapPropertySource(KubernetesClient client, String name) {
        this(client, name, null, (Environment)null);
    }

    public ConfigMapPropertySource(KubernetesClient client, String name, String namespace, String[] profiles) {
        this(client, name, namespace, ConfigMapPropertySource.createEnvironmentWithActiveProfiles(profiles));
    }

    private static Environment createEnvironmentWithActiveProfiles(String[] activeProfiles) {
        StandardEnvironment environment = new StandardEnvironment();
        environment.setActiveProfiles(activeProfiles);
        return environment;
    }

    public ConfigMapPropertySource(KubernetesClient client, String name, String namespace, Environment environment) {
        super(ConfigMapPropertySource.getName(client, name, namespace), ConfigMapPropertySource.asObjectMap(ConfigMapPropertySource.getData(client, name, namespace, environment)));
    }

    private static String getName(KubernetesClient client, String name, String namespace) {
        return PREFIX + "." + name + "." + (namespace == null || namespace.isEmpty() ? client.getNamespace() : namespace);
    }

    private static Map<String, String> getData(KubernetesClient client, String name, String namespace, Environment environment) {
        try {
            ConfigMap map;
            HashMap<String, String> result = new HashMap<String, String>();
            ConfigMap configMap = map = StringUtils.isEmpty((Object)namespace) ? (ConfigMap)((Resource)client.configMaps().withName(name)).get() : (ConfigMap)((Resource)((NonNamespaceOperation)client.configMaps().inNamespace(namespace)).withName(name)).get();
            if (map != null) {
                result.putAll(ConfigMapPropertySource.processAllEntries(map.getData(), environment));
            }
            if (environment != null) {
                for (String activeProfile : environment.getActiveProfiles()) {
                    ConfigMap mapWithProfile;
                    String mapNameWithProfile = name + "-" + activeProfile;
                    ConfigMap configMap2 = mapWithProfile = StringUtils.isEmpty((Object)namespace) ? (ConfigMap)((Resource)client.configMaps().withName(mapNameWithProfile)).get() : (ConfigMap)((Resource)((NonNamespaceOperation)client.configMaps().inNamespace(namespace)).withName(mapNameWithProfile)).get();
                    if (mapWithProfile == null) continue;
                    result.putAll(ConfigMapPropertySource.processAllEntries(mapWithProfile.getData(), environment));
                }
            }
            return result;
        }
        catch (Exception e) {
            LOG.warn((Object)("Can't read configMap with name: [" + name + "] in namespace:[" + namespace + "]. Ignoring"));
            return new HashMap<String, String>();
        }
    }

    private static Map<String, String> processAllEntries(Map<String, String> input, Environment environment) {
        Set<Map.Entry<String, String>> entrySet = input.entrySet();
        if (entrySet.size() == 1) {
            Map.Entry<String, String> singleEntry = entrySet.iterator().next();
            String propertyName = singleEntry.getKey();
            String propertyValue = singleEntry.getValue();
            if (propertyName.endsWith(".yml") || propertyName.endsWith(".yaml")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("The single property with name: [" + propertyName + "] will be treated as a yaml file"));
                }
                return PropertySourceUtils.yamlParserGenerator(environment).andThen(PropertySourceUtils.PROPERTIES_TO_MAP).apply(propertyValue);
            }
            if (propertyName.endsWith(".properties")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("The single property with name: [" + propertyName + "] will be treated as a properties file"));
                }
                return PropertySourceUtils.KEY_VALUE_TO_PROPERTIES.andThen(PropertySourceUtils.PROPERTIES_TO_MAP).apply(propertyValue);
            }
            return ConfigMapPropertySource.defaultProcessAllEntries(input, environment);
        }
        return ConfigMapPropertySource.defaultProcessAllEntries(input, environment);
    }

    private static Map<String, String> defaultProcessAllEntries(Map<String, String> input, Environment environment) {
        return input.entrySet().stream().map(e -> ConfigMapPropertySource.extractProperties((String)e.getKey(), (String)e.getValue(), environment)).filter(m -> !m.isEmpty()).flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static Map<String, String> extractProperties(final String resourceName, final String content, Environment environment) {
        if (resourceName.equals(APPLICATION_YAML) || resourceName.equals(APPLICATION_YML)) {
            return PropertySourceUtils.yamlParserGenerator(environment).andThen(PropertySourceUtils.PROPERTIES_TO_MAP).apply(content);
        }
        if (resourceName.equals(APPLICATION_PROPERTIES)) {
            return PropertySourceUtils.KEY_VALUE_TO_PROPERTIES.andThen(PropertySourceUtils.PROPERTIES_TO_MAP).apply(content);
        }
        return new HashMap<String, String>(){
            {
                this.put(resourceName, content);
            }
        };
    }

    private static Map<String, Object> asObjectMap(Map<String, String> source) {
        return source.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

