/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.config;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.kubernetes.config.ConfigUtils;
import org.springframework.cloud.kubernetes.config.SecretsConfigProperties;
import org.springframework.cloud.kubernetes.config.SecretsPropertySource;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

@Order(value=1)
public class SecretsPropertySourceLocator
implements PropertySourceLocator {
    private static final Log LOG = LogFactory.getLog(SecretsPropertySourceLocator.class);
    private final KubernetesClient client;
    private final SecretsConfigProperties properties;

    public SecretsPropertySourceLocator(KubernetesClient client, SecretsConfigProperties properties) {
        this.client = client;
        this.properties = properties;
    }

    public PropertySource locate(Environment environment) {
        if (environment instanceof ConfigurableEnvironment) {
            ConfigurableEnvironment env = (ConfigurableEnvironment)environment;
            List<SecretsConfigProperties.NormalizedSource> sources = this.properties.determineSources();
            CompositePropertySource composite = new CompositePropertySource("composite-secrets");
            if (this.properties.isEnableApi()) {
                sources.forEach(s -> composite.addFirstPropertySource((PropertySource)this.getKubernetesPropertySourceForSingleSecret(env, (SecretsConfigProperties.NormalizedSource)s)));
            }
            this.putPathConfig(composite);
            return composite;
        }
        return null;
    }

    private MapPropertySource getKubernetesPropertySourceForSingleSecret(ConfigurableEnvironment environment, SecretsConfigProperties.NormalizedSource normalizedSource) {
        String configurationTarget = this.properties.getConfigurationTarget();
        return new SecretsPropertySource(this.client, (Environment)environment, ConfigUtils.getApplicationName((Environment)environment, normalizedSource.getName(), configurationTarget), ConfigUtils.getApplicationNamespace(this.client, normalizedSource.getNamespace(), configurationTarget), normalizedSource.getLabels());
    }

    private void putPathConfig(CompositePropertySource composite) {
        this.properties.getPaths().stream().map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).forEach(p -> this.putAll((Path)p, composite));
    }

    private void putAll(Path path, CompositePropertySource composite) {
        try {
            Files.walk(path, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(p -> this.readFile((Path)p, composite));
        }
        catch (IOException e) {
            LOG.warn((Object)"Error walking properties files", (Throwable)e);
        }
    }

    private void readFile(Path path, CompositePropertySource composite) {
        try {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put(path.getFileName().toString(), new String(Files.readAllBytes(path)).trim());
            if (!result.isEmpty()) {
                composite.addFirstPropertySource((PropertySource)new MapPropertySource(path.getFileName().toString().toLowerCase(), result));
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Error reading properties file", (Throwable)e);
        }
    }
}

