/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.profile;

import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import org.springframework.cloud.kubernetes.commons.profile.AbstractKubernetesProfileEnvironmentPostProcessor;
import org.springframework.cloud.kubernetes.fabric8.Fabric8PodUtils;
import org.springframework.core.env.Environment;

public class Fabric8ProfileEnvironmentPostProcessor
extends AbstractKubernetesProfileEnvironmentPostProcessor {
    protected static final String KUBERNETES_SERVICE_ENV_VAR = "KUBERNETES_SERVICE_HOST";

    protected boolean isInsideKubernetes(Environment environment) {
        try (DefaultKubernetesClient client = new DefaultKubernetesClient();){
            Fabric8PodUtils podUtils = new Fabric8PodUtils((KubernetesClient)client);
            boolean bl = environment.containsProperty(KUBERNETES_SERVICE_ENV_VAR) || podUtils.isInsideKubernetes() != false;
            return bl;
        }
    }
}

