/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.config;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.client.KubernetesClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.kubernetes.commons.KubernetesCommonsAutoConfiguration;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.KubernetesBootstrapConfiguration;
import org.springframework.cloud.kubernetes.commons.config.SecretsConfigProperties;
import org.springframework.cloud.kubernetes.fabric8.Fabric8AutoConfiguration;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8SecretsPropertySourceLocator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.cloud.kubernetes.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={ConfigMap.class, Secret.class})
@AutoConfigureAfter(value={KubernetesBootstrapConfiguration.class})
public class Fabric8BootstrapConfiguration {

    @Configuration(proxyBeanMethods=false)
    @Import(value={KubernetesCommonsAutoConfiguration.class, Fabric8AutoConfiguration.class})
    protected static class KubernetesPropertySourceConfiguration {
        @Autowired
        private KubernetesClient client;

        protected KubernetesPropertySourceConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(name={"spring.cloud.kubernetes.config.enabled"}, matchIfMissing=true)
        public Fabric8ConfigMapPropertySourceLocator configMapPropertySourceLocator(ConfigMapConfigProperties properties) {
            return new Fabric8ConfigMapPropertySourceLocator(this.client, properties);
        }

        @Bean
        @ConditionalOnProperty(name={"spring.cloud.kubernetes.secrets.enabled"}, matchIfMissing=true)
        public Fabric8SecretsPropertySourceLocator secretsPropertySourceLocator(SecretsConfigProperties properties) {
            return new Fabric8SecretsPropertySourceLocator(this.client, properties);
        }
    }
}

