/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.config.reload;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.concurrent.ThreadLocalRandom;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadProperties;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationChangeDetector;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationUpdateStrategy;
import org.springframework.cloud.kubernetes.commons.config.reload.PollingConfigMapChangeDetector;
import org.springframework.cloud.kubernetes.commons.config.reload.PollingSecretsChangeDetector;
import org.springframework.cloud.kubernetes.commons.config.reload.condition.EventReloadDetectionMode;
import org.springframework.cloud.kubernetes.commons.config.reload.condition.PollingReloadDetectionMode;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ConfigMapPropertySource;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8SecretsPropertySource;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8SecretsPropertySourceLocator;
import org.springframework.cloud.kubernetes.fabric8.config.reload.ConfigReloadAutoConfiguration;
import org.springframework.cloud.kubernetes.fabric8.config.reload.EventBasedConfigMapChangeDetector;
import org.springframework.cloud.kubernetes.fabric8.config.reload.EventBasedSecretsChangeDetector;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.cloud.kubernetes.enabled"}, matchIfMissing=true)
@ConditionalOnMissingBean(value={ConfigReloadAutoConfiguration.class})
@EnableConfigurationProperties(value={ConfigReloadProperties.class})
public class ConfigReloadDefaultAutoConfiguration {

    @ConditionalOnProperty(value={"spring.cloud.kubernetes.reload.enabled"})
    @EnableScheduling
    @EnableAsync
    protected static class ConfigReloadAutoConfigurationBeans {
        @Autowired
        private AbstractEnvironment environment;
        @Autowired
        private KubernetesClient kubernetesClient;
        @Autowired
        private Fabric8ConfigMapPropertySourceLocator fabric8ConfigMapPropertySourceLocator;
        @Autowired
        private Fabric8SecretsPropertySourceLocator fabric8SecretsPropertySourceLocator;

        protected ConfigReloadAutoConfigurationBeans() {
        }

        private static void wait(ConfigReloadProperties properties) {
            long waitMillis = ThreadLocalRandom.current().nextLong(properties.getMaxWaitForRestart().toMillis());
            try {
                Thread.sleep(waitMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Bean
        @ConditionalOnBean(value={Fabric8ConfigMapPropertySourceLocator.class})
        @Conditional(value={PollingReloadDetectionMode.class})
        public ConfigurationChangeDetector configMapPropertyChangePollingWatcher(ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy, Fabric8ConfigMapPropertySourceLocator fabric8ConfigMapPropertySourceLocator) {
            return new PollingConfigMapChangeDetector(this.environment, properties, strategy, Fabric8ConfigMapPropertySource.class, (PropertySourceLocator)fabric8ConfigMapPropertySourceLocator);
        }

        @Bean
        @ConditionalOnBean(value={Fabric8SecretsPropertySourceLocator.class})
        @Conditional(value={PollingReloadDetectionMode.class})
        public ConfigurationChangeDetector secretsPropertyChangePollingWatcher(ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy, Fabric8SecretsPropertySourceLocator fabric8SecretsPropertySourceLocator) {
            return new PollingSecretsChangeDetector(this.environment, properties, strategy, Fabric8SecretsPropertySource.class, (PropertySourceLocator)fabric8SecretsPropertySourceLocator);
        }

        @Bean
        @ConditionalOnBean(value={Fabric8ConfigMapPropertySourceLocator.class})
        @Conditional(value={EventReloadDetectionMode.class})
        public ConfigurationChangeDetector configMapPropertyChangeEventWatcher(ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy, Fabric8ConfigMapPropertySourceLocator fabric8ConfigMapPropertySourceLocator) {
            return new EventBasedConfigMapChangeDetector(this.environment, properties, this.kubernetesClient, strategy, fabric8ConfigMapPropertySourceLocator);
        }

        @Bean
        @ConditionalOnBean(value={Fabric8SecretsPropertySourceLocator.class})
        @Conditional(value={EventReloadDetectionMode.class})
        public ConfigurationChangeDetector secretsPropertyChangeEventWatcher(ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy, Fabric8SecretsPropertySourceLocator fabric8SecretsPropertySourceLocator) {
            return new EventBasedSecretsChangeDetector(this.environment, properties, this.kubernetesClient, strategy, fabric8SecretsPropertySourceLocator);
        }

        @Bean
        @ConditionalOnMissingBean
        public ConfigurationUpdateStrategy configurationUpdateStrategy(ConfigReloadProperties properties, ConfigurableApplicationContext ctx) {
            switch (properties.getStrategy()) {
                case SHUTDOWN: {
                    return new ConfigurationUpdateStrategy(properties.getStrategy().name(), () -> {
                        ConfigReloadAutoConfigurationBeans.wait(properties);
                        ctx.close();
                    });
                }
            }
            throw new IllegalStateException("Unsupported configuration update strategy: " + properties.getStrategy());
        }
    }
}

