/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.discovery;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;

class ServicePortSecureResolver {
    private static final Log LOG = LogFactory.getLog(ServicePortSecureResolver.class);
    private static final Set<String> TRUTHY_STRINGS = Stream.of("true", "on", "yes", "1").collect(Collectors.toSet());
    private final KubernetesDiscoveryProperties properties;

    ServicePortSecureResolver(KubernetesDiscoveryProperties properties) {
        this.properties = properties;
    }

    boolean resolve(Input input) {
        String securedLabelValue = input.serviceLabels.getOrDefault("secured", "false");
        if (TRUTHY_STRINGS.contains(securedLabelValue)) {
            LOG.debug((Object)("Considering service with name: " + input.serviceName + " and port " + input.port + " is secure since the service contains a true value for the 'secured' label"));
            return true;
        }
        String securedAnnotationValue = input.serviceAnnotations.getOrDefault("secured", "false");
        if (TRUTHY_STRINGS.contains(securedAnnotationValue)) {
            LOG.debug((Object)("Considering service with name: " + input.serviceName + " and port " + input.port + " is secure since the service contains a true value for the 'secured' annotation"));
            return true;
        }
        if (input.port != null && this.properties.getKnownSecurePorts().contains(input.port)) {
            LOG.debug((Object)("Considering service with name: " + input.serviceName + " and port " + input.port + " is secure due to the port being a known https port"));
            return true;
        }
        return false;
    }

    static final class Input {
        private final Integer port;
        private final String serviceName;
        private final Map<String, String> serviceLabels;
        private final Map<String, String> serviceAnnotations;

        Input(Integer port, String serviceName) {
            this(port, serviceName, null, null);
        }

        Input(Integer port, String serviceName, Map<String, String> serviceLabels, Map<String, String> serviceAnnotations) {
            this.port = port;
            this.serviceName = serviceName;
            this.serviceLabels = serviceLabels == null ? Collections.emptyMap() : serviceLabels;
            this.serviceAnnotations = serviceAnnotations == null ? Collections.emptyMap() : serviceAnnotations;
        }
    }
}

