/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.discovery;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.cloud.kubernetes.commons.discovery.PodLabelsAndAnnotations;

final class Fabric8PodLabelsAndAnnotationsSupplier
implements Function<String, PodLabelsAndAnnotations> {
    private final KubernetesClient client;
    private final String namespace;

    private Fabric8PodLabelsAndAnnotationsSupplier(KubernetesClient client, String namespace) {
        this.client = client;
        this.namespace = namespace;
    }

    static Fabric8PodLabelsAndAnnotationsSupplier nonExternalName(KubernetesClient client, String namespace) {
        return new Fabric8PodLabelsAndAnnotationsSupplier(client, namespace);
    }

    static Fabric8PodLabelsAndAnnotationsSupplier externalName() {
        return new Fabric8PodLabelsAndAnnotationsSupplier(null, null);
    }

    @Override
    public PodLabelsAndAnnotations apply(String podName) {
        ObjectMeta metadata = Optional.ofNullable((Pod)((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(this.namespace)).withName(podName)).get()).map(Pod::getMetadata).orElse(new ObjectMeta());
        return new PodLabelsAndAnnotations(metadata.getLabels(), metadata.getAnnotations());
    }
}

