/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.discovery;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.fabric8.Fabric8Utils;
import org.springframework.cloud.kubernetes.fabric8.discovery.KubernetesClientServicesFunction;
import org.springframework.core.env.Environment;

public final class KubernetesClientServicesFunctionProvider {
    private KubernetesClientServicesFunctionProvider() {
    }

    public static KubernetesClientServicesFunction servicesFunction(KubernetesDiscoveryProperties properties, Environment environment) {
        if (properties.allNamespaces()) {
            return client -> (FilterWatchListDeletable)((AnyNamespaceOperation)client.services().inAnyNamespace()).withLabels(properties.serviceLabels());
        }
        return client -> {
            String namespace = Fabric8Utils.getApplicationNamespace((KubernetesClient)client, null, (String)"discovery-service", (KubernetesNamespaceProvider)new KubernetesNamespaceProvider(environment));
            return (FilterWatchListDeletable)((NonNamespaceOperation)client.services().inNamespace(namespace)).withLabels(properties.serviceLabels());
        };
    }

    @Deprecated(forRemoval=true)
    public static KubernetesClientServicesFunction servicesFunction(KubernetesDiscoveryProperties properties, Binder binder, BindHandler bindHandler) {
        return KubernetesClientServicesFunctionProvider.servicesFunction(properties, new KubernetesNamespaceProvider(binder, bindHandler));
    }

    public static KubernetesClientServicesFunction servicesFunction(KubernetesDiscoveryProperties properties, KubernetesNamespaceProvider namespaceProvider) {
        if (properties.allNamespaces()) {
            return client -> (FilterWatchListDeletable)((AnyNamespaceOperation)client.services().inAnyNamespace()).withLabels(properties.serviceLabels());
        }
        return client -> {
            String namespace = Fabric8Utils.getApplicationNamespace((KubernetesClient)client, null, (String)"discovery-service", (KubernetesNamespaceProvider)namespaceProvider);
            return (FilterWatchListDeletable)((NonNamespaceOperation)client.services().inNamespace(namespace)).withLabels(properties.serviceLabels());
        };
    }
}

