/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.loadbalancer;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.client.utils.Utils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.springframework.cloud.kubernetes.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.discovery.KubernetesServiceInstance;
import org.springframework.cloud.kubernetes.loadbalancer.KubernetesLoadBalancerProperties;

public class KubernetesServiceInstanceMapper {
    private final KubernetesLoadBalancerProperties properties;
    private final KubernetesDiscoveryProperties discoveryProperties;

    KubernetesServiceInstanceMapper(KubernetesLoadBalancerProperties properties, KubernetesDiscoveryProperties discoveryProperties) {
        this.properties = properties;
        this.discoveryProperties = discoveryProperties;
    }

    public KubernetesServiceInstance map(Service service) {
        Optional<ServicePort> optPort;
        ObjectMeta meta = service.getMetadata();
        List ports = service.getSpec().getPorts();
        ServicePort port = null;
        if (ports.size() == 1) {
            port = (ServicePort)ports.get(0);
        } else if (ports.size() > 1 && Utils.isNotNullOrEmpty((String)this.properties.getPortName()) && (optPort = ports.stream().filter(it -> this.properties.getPortName().endsWith(it.getName())).findAny()).isPresent()) {
            port = optPort.get();
        }
        if (port == null) {
            return null;
        }
        String host = this.createHost(service);
        boolean secure = this.isSecure(service, port);
        return new KubernetesServiceInstance(meta.getUid(), meta.getName(), host, port.getPort().intValue(), this.getServiceMetadata(service), Boolean.valueOf(secure));
    }

    private Map<String, String> getServiceMetadata(Service service) {
        HashMap<String, String> serviceMetadata = new HashMap<String, String>();
        KubernetesDiscoveryProperties.Metadata metadataProps = this.discoveryProperties.getMetadata();
        if (metadataProps.isAddLabels()) {
            Map<String, String> labelMetadata = this.getMapWithPrefixedKeys(service.getMetadata().getLabels(), metadataProps.getLabelsPrefix());
            serviceMetadata.putAll(labelMetadata);
        }
        if (metadataProps.isAddAnnotations()) {
            Map<String, String> annotationMetadata = this.getMapWithPrefixedKeys(service.getMetadata().getAnnotations(), metadataProps.getAnnotationsPrefix());
            serviceMetadata.putAll(annotationMetadata);
        }
        return serviceMetadata;
    }

    private Map<String, String> getMapWithPrefixedKeys(Map<String, String> map, String prefix) {
        if (map == null) {
            return new HashMap<String, String>();
        }
        if (!org.springframework.util.StringUtils.hasText((String)prefix)) {
            return map;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        map.forEach((k, v) -> result.put(prefix + k, (String)v));
        return result;
    }

    private boolean isSecure(Service service, ServicePort port) {
        String securedAnnotationValue;
        String securedLabelValue;
        if (service.getMetadata().getLabels() != null && (securedLabelValue = service.getMetadata().getLabels().getOrDefault("secured", "false")).equals("true")) {
            return true;
        }
        if (service.getMetadata().getAnnotations() != null && (securedAnnotationValue = service.getMetadata().getAnnotations().getOrDefault("secured", "false")).equals("true")) {
            return true;
        }
        return port.getName() != null && port.getName().endsWith("https") || port.getPort().toString().endsWith("443");
    }

    private String createHost(Service service) {
        return String.format("%s.%s.svc.%s", service.getMetadata().getName(), StringUtils.isNotBlank((String)service.getMetadata().getNamespace()) ? service.getMetadata().getNamespace() : "default", this.properties.getClusterDomain());
    }
}

