/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.core;

import java.util.List;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceSupplier;
import org.springframework.core.env.Environment;
import reactor.core.publisher.Flux;

public class DiscoveryClientServiceInstanceSupplier
implements ServiceInstanceSupplier {
    private final DiscoveryClient delegate;
    private final String serviceId;

    public DiscoveryClientServiceInstanceSupplier(DiscoveryClient delegate, Environment environment) {
        this.delegate = delegate;
        this.serviceId = environment.getProperty("loadbalancer.client.name");
    }

    @Override
    public Flux<ServiceInstance> get() {
        List instances = this.delegate.getInstances(this.serviceId);
        return Flux.fromIterable((Iterable)instances);
    }

    @Override
    public String getServiceId() {
        return this.serviceId;
    }
}

