/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.blocking.retry;

import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryContext;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicy;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRetryProperties;
import org.springframework.cloud.client.loadbalancer.ServiceInstanceChooser;
import org.springframework.http.HttpMethod;

public class BlockingLoadBalancedRetryPolicy
implements LoadBalancedRetryPolicy {
    private final LoadBalancerRetryProperties retryProperties;
    private final ServiceInstanceChooser serviceInstanceChooser;
    private final String serviceId;
    private int sameServerCount = 0;
    private int nextServerCount = 0;

    public BlockingLoadBalancedRetryPolicy(String serviceId, ServiceInstanceChooser serviceInstanceChooser, LoadBalancerRetryProperties retryProperties) {
        this.serviceId = serviceId;
        this.serviceInstanceChooser = serviceInstanceChooser;
        this.retryProperties = retryProperties;
    }

    public boolean canRetry(LoadBalancedRetryContext context) {
        HttpMethod method = context.getRequest().getMethod();
        return HttpMethod.GET.equals((Object)method) || this.retryProperties.isRetryOnAllOperations();
    }

    public boolean canRetrySameServer(LoadBalancedRetryContext context) {
        return this.sameServerCount < this.retryProperties.getMaxRetriesOnSameServiceInstance() && this.canRetry(context);
    }

    public boolean canRetryNextServer(LoadBalancedRetryContext context) {
        return this.nextServerCount <= this.retryProperties.getMaxRetriesOnNextServiceInstance() && this.canRetry(context);
    }

    public void close(LoadBalancedRetryContext context) {
    }

    public void registerThrowable(LoadBalancedRetryContext context, Throwable throwable) {
        if (!this.canRetrySameServer(context) && this.canRetry(context)) {
            this.sameServerCount = 0;
            ++this.nextServerCount;
            if (!this.canRetryNextServer(context)) {
                context.setExhaustedOnly();
            } else {
                context.setServiceInstance(this.serviceInstanceChooser.choose(this.serviceId));
            }
        } else {
            ++this.sameServerCount;
        }
    }

    public boolean retryableStatusCode(int statusCode) {
        return this.retryProperties.getRetryableStatusCodes().contains(statusCode);
    }
}

