/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.loadbalancer.config.LoadBalancerZoneConfig;
import org.springframework.cloud.loadbalancer.core.DelegatingServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import reactor.core.publisher.Flux;

public class ZonePreferenceServiceInstanceListSupplier
extends DelegatingServiceInstanceListSupplier {
    private final String ZONE = "zone";
    private final LoadBalancerZoneConfig zoneConfig;
    private String zone;

    public ZonePreferenceServiceInstanceListSupplier(ServiceInstanceListSupplier delegate, LoadBalancerZoneConfig zoneConfig) {
        super(delegate);
        this.zoneConfig = zoneConfig;
    }

    @Override
    public Flux<List<ServiceInstance>> get() {
        return ((Flux)this.getDelegate().get()).map(this::filteredByZone);
    }

    private List<ServiceInstance> filteredByZone(List<ServiceInstance> serviceInstances) {
        if (this.zone == null) {
            this.zone = this.zoneConfig.getZone();
        }
        if (this.zone != null) {
            ArrayList<ServiceInstance> filteredInstances = new ArrayList<ServiceInstance>();
            for (ServiceInstance serviceInstance : serviceInstances) {
                String instanceZone = this.getZone(serviceInstance);
                if (!this.zone.equalsIgnoreCase(instanceZone)) continue;
                filteredInstances.add(serviceInstance);
            }
            if (filteredInstances.size() > 0) {
                return filteredInstances;
            }
        }
        return serviceInstances;
    }

    private String getZone(ServiceInstance serviceInstance) {
        Map metadata = serviceInstance.getMetadata();
        if (metadata != null) {
            return (String)metadata.get("zone");
        }
        return null;
    }
}

