/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.core;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.loadbalancer.core.DelegatingServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.LazyWeightedServiceInstanceList;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.WeightFunction;
import reactor.core.publisher.Flux;

public class WeightedServiceInstanceListSupplier
extends DelegatingServiceInstanceListSupplier {
    private static final Log LOG = LogFactory.getLog(WeightedServiceInstanceListSupplier.class);
    static final String METADATA_WEIGHT_KEY = "weight";
    static final int DEFAULT_WEIGHT = 1;
    private final WeightFunction weightFunction;

    public WeightedServiceInstanceListSupplier(ServiceInstanceListSupplier delegate) {
        super(delegate);
        this.weightFunction = WeightedServiceInstanceListSupplier::metadataWeightFunction;
    }

    public WeightedServiceInstanceListSupplier(ServiceInstanceListSupplier delegate, WeightFunction weightFunction) {
        super(delegate);
        this.weightFunction = weightFunction;
    }

    @Override
    public Flux<List<ServiceInstance>> get() {
        return ((Flux)this.delegate.get()).map(this::expandByWeight);
    }

    private List<ServiceInstance> expandByWeight(List<ServiceInstance> instances) {
        if (instances.size() == 0) {
            return instances;
        }
        int[] weights = instances.stream().mapToInt(instance -> {
            try {
                int weight = this.weightFunction.apply((ServiceInstance)instance);
                if (weight <= 0) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)String.format("The weight of the instance %s should be a positive integer, but it got %d, using %d as default", instance.getInstanceId(), weight, 1));
                    }
                    return 1;
                }
                return weight;
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Exception occurred during apply weight function to instance %s, using %d as default", instance.getInstanceId(), 1), (Throwable)e);
                }
                return 1;
            }
        }).toArray();
        return new LazyWeightedServiceInstanceList(instances, weights);
    }

    static int metadataWeightFunction(ServiceInstance serviceInstance) {
        String weightValue;
        Map metadata = serviceInstance.getMetadata();
        if (metadata != null && (weightValue = (String)metadata.get(METADATA_WEIGHT_KEY)) != null) {
            return Integer.parseInt(weightValue);
        }
        return 1;
    }
}

