/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.config;

import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.endpoint.EndpointUtils;
import com.netflix.discovery.shared.resolver.DefaultEndpoint;
import java.util.List;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.config.client.ConfigServerConfigDataLocationResolver;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public final class HostnameBasedUrlRandomizer
implements EndpointUtils.ServiceUrlRandomizer {
    private static final String EUREKA_INSTANCE_HOSTNAME = "eureka.instance.hostname";
    private final String hostname;

    HostnameBasedUrlRandomizer(String hostname) {
        this.hostname = hostname;
    }

    public void randomize(List<String> urlList) {
        int listSize = 0;
        if (urlList != null) {
            listSize = urlList.size();
        }
        if (!StringUtils.hasText((String)this.hostname) || listSize == 0) {
            return;
        }
        int instanceHashcode = this.hostname.hashCode();
        if (instanceHashcode < 0) {
            instanceHashcode *= -1;
        }
        int backupInstance = instanceHashcode % listSize;
        for (int i = 0; i < backupInstance; ++i) {
            String zone = urlList.remove(0);
            urlList.add(zone);
        }
    }

    public static String getEurekaUrl(EurekaClientConfig config, String hostname) {
        List urls = EndpointUtils.getDiscoveryServiceUrls((EurekaClientConfig)config, (String)"defaultZone", (EndpointUtils.ServiceUrlRandomizer)new HostnameBasedUrlRandomizer(hostname));
        return (String)urls.get(0);
    }

    public static DefaultEndpoint randomEndpoint(EurekaClientConfig config, Environment env) {
        String hostname = env.getProperty(EUREKA_INSTANCE_HOSTNAME);
        return new DefaultEndpoint(HostnameBasedUrlRandomizer.getEurekaUrl(config, hostname));
    }

    public static DefaultEndpoint randomEndpoint(EurekaClientConfig config, Binder binder) {
        String hostname = (String)binder.bind(EUREKA_INSTANCE_HOSTNAME, String.class).orElseGet(() -> null);
        return new DefaultEndpoint(HostnameBasedUrlRandomizer.getEurekaUrl(config, hostname));
    }

    public static DefaultEndpoint randomEndpoint(EurekaClientConfig config, ConfigServerConfigDataLocationResolver.PropertyResolver propertyResolver) {
        String hostname = (String)propertyResolver.get(EUREKA_INSTANCE_HOSTNAME, String.class, null);
        return new DefaultEndpoint(HostnameBasedUrlRandomizer.getEurekaUrl(config, hostname));
    }
}

