/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.hystrix;

import com.netflix.hystrix.HystrixObservableCommand;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreaker;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import rx.Observable;
import rx.RxReactiveStreams;
import rx.Subscription;

public class ReactiveHystrixCircuitBreaker
implements ReactiveCircuitBreaker {
    private HystrixObservableCommand.Setter setter;

    public ReactiveHystrixCircuitBreaker(HystrixObservableCommand.Setter setter) {
        this.setter = setter;
    }

    public <T> Mono<T> run(Mono<T> toRun, Function<Throwable, Mono<T>> fallback) {
        HystrixObservableCommand command = this.createCommand((Publisher<T>)toRun, fallback);
        return Mono.create(s -> {
            Subscription sub = command.toObservable().subscribe(arg_0 -> ((MonoSink)s).success(arg_0), arg_0 -> ((MonoSink)s).error(arg_0), () -> ((MonoSink)s).success());
            s.onCancel(() -> ((Subscription)sub).unsubscribe());
        });
    }

    public <T> Flux<T> run(Flux<T> toRun, Function<Throwable, Flux<T>> fallback) {
        HystrixObservableCommand command = this.createCommand((Publisher<T>)toRun, fallback);
        return Flux.create(s -> {
            Subscription sub = command.toObservable().subscribe(arg_0 -> ((FluxSink)s).next(arg_0), arg_0 -> ((FluxSink)s).error(arg_0), () -> ((FluxSink)s).complete());
            s.onCancel(() -> ((Subscription)sub).unsubscribe());
        });
    }

    private <T> HystrixObservableCommand<T> createCommand(final Publisher<T> toRun, final Function fallback) {
        HystrixObservableCommand command = new HystrixObservableCommand<T>(this.setter){

            protected Observable<T> construct() {
                return RxReactiveStreams.toObservable((Publisher)toRun);
            }

            protected Observable<T> resumeWithFallback() {
                if (fallback == null) {
                    super.resumeWithFallback();
                }
                return RxReactiveStreams.toObservable((Publisher)((Publisher)fallback.apply(this.getExecutionException())));
            }
        };
        return command;
    }
}

