/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.hystrix;

import com.netflix.hystrix.Hystrix;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.circuitbreaker.CircuitBreakerFactory;
import org.springframework.cloud.client.circuitbreaker.Customizer;
import org.springframework.cloud.netflix.hystrix.HystrixCircuitBreakerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Hystrix.class})
@ConditionalOnProperty(name={"spring.cloud.circuitbreaker.hystrix.enabled"}, matchIfMissing=true)
public class HystrixCircuitBreakerAutoConfiguration {
    @Autowired(required=false)
    private List<Customizer<HystrixCircuitBreakerFactory>> customizers = new ArrayList<Customizer<HystrixCircuitBreakerFactory>>();

    @Bean
    @ConditionalOnMissingBean(value={CircuitBreakerFactory.class})
    public CircuitBreakerFactory hystrixCircuitBreakerFactory() {
        HystrixCircuitBreakerFactory factory = new HystrixCircuitBreakerFactory();
        this.customizers.forEach(customizer -> customizer.customize((Object)factory));
        return factory;
    }
}

