/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon;

import com.netflix.client.ClientRequest;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.http.HttpRequest;
import com.netflix.client.http.HttpResponse;
import com.netflix.niws.client.http.RestClient;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import org.springframework.cloud.netflix.ribbon.RibbonHttpResponse;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.AbstractClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;

public class RibbonHttpRequest
extends AbstractClientHttpRequest {
    private HttpRequest.Builder builder;
    private URI uri;
    private HttpRequest.Verb verb;
    private RestClient client;
    private IClientConfig config;
    private ByteArrayOutputStream outputStream = null;

    public RibbonHttpRequest(URI uri, HttpRequest.Verb verb, RestClient client, IClientConfig config) {
        this.uri = uri;
        this.verb = verb;
        this.client = client;
        this.config = config;
        this.builder = HttpRequest.newBuilder().uri(uri).verb(verb);
    }

    public HttpMethod getMethod() {
        return HttpMethod.valueOf((String)this.verb.name());
    }

    public String getMethodValue() {
        return this.getMethod().name();
    }

    public URI getURI() {
        return this.uri;
    }

    protected OutputStream getBodyInternal(HttpHeaders headers) throws IOException {
        if (this.outputStream == null) {
            this.outputStream = new ByteArrayOutputStream();
        }
        return this.outputStream;
    }

    protected ClientHttpResponse executeInternal(HttpHeaders headers) throws IOException {
        try {
            this.addHeaders(headers);
            if (this.outputStream != null) {
                this.outputStream.close();
                this.builder.entity((Object)this.outputStream.toByteArray());
            }
            HttpRequest request = this.builder.build();
            HttpResponse response = (HttpResponse)this.client.executeWithLoadBalancer((ClientRequest)request, this.config);
            return new RibbonHttpResponse(response);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void addHeaders(HttpHeaders headers) {
        for (String name : headers.keySet()) {
            if (this.isDynamic(name) && this.outputStream != null || name.equals("Content-Length") && this.outputStream == null) continue;
            List values = headers.get((Object)name);
            for (String value : values) {
                this.builder.header(name, value);
            }
        }
    }

    private boolean isDynamic(String name) {
        return "Content-Length".equalsIgnoreCase(name) || "Transfer-Encoding".equalsIgnoreCase(name);
    }
}

