/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon.okhttp;

import com.netflix.client.AbstractLoadBalancerAwareClient;
import com.netflix.client.RetryHandler;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.servo.monitor.Monitors;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryFactory;
import org.springframework.cloud.commons.httpclient.OkHttpClientConnectionPoolFactory;
import org.springframework.cloud.commons.httpclient.OkHttpClientFactory;
import org.springframework.cloud.netflix.ribbon.RibbonClientName;
import org.springframework.cloud.netflix.ribbon.RibbonLoadBalancerContext;
import org.springframework.cloud.netflix.ribbon.RibbonProperties;
import org.springframework.cloud.netflix.ribbon.ServerIntrospector;
import org.springframework.cloud.netflix.ribbon.okhttp.OkHttpLoadBalancingClient;
import org.springframework.cloud.netflix.ribbon.okhttp.RetryableOkHttpLoadBalancingClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"ribbon.okhttp.enabled"})
@ConditionalOnClass(name={"okhttp3.OkHttpClient"})
public class OkHttpRibbonConfiguration {
    @RibbonClientName
    private String name = "client";

    @Bean
    @ConditionalOnMissingBean(value={AbstractLoadBalancerAwareClient.class})
    @ConditionalOnClass(name={"org.springframework.retry.support.RetryTemplate"})
    public RetryableOkHttpLoadBalancingClient retryableOkHttpLoadBalancingClient(IClientConfig config, ServerIntrospector serverIntrospector, ILoadBalancer loadBalancer, RetryHandler retryHandler, LoadBalancedRetryFactory loadBalancedRetryFactory, OkHttpClient delegate, RibbonLoadBalancerContext ribbonLoadBalancerContext) {
        RetryableOkHttpLoadBalancingClient client = new RetryableOkHttpLoadBalancingClient(delegate, config, serverIntrospector, loadBalancedRetryFactory);
        client.setLoadBalancer(loadBalancer);
        client.setRetryHandler(retryHandler);
        client.setRibbonLoadBalancerContext(ribbonLoadBalancerContext);
        Monitors.registerObject((String)("Client_" + this.name), (Object)((Object)client));
        return client;
    }

    @Bean
    @ConditionalOnMissingBean(value={AbstractLoadBalancerAwareClient.class})
    @ConditionalOnMissingClass(value={"org.springframework.retry.support.RetryTemplate"})
    public OkHttpLoadBalancingClient okHttpLoadBalancingClient(IClientConfig config, ServerIntrospector serverIntrospector, ILoadBalancer loadBalancer, RetryHandler retryHandler, OkHttpClient delegate) {
        OkHttpLoadBalancingClient client = new OkHttpLoadBalancingClient(delegate, config, serverIntrospector);
        client.setLoadBalancer(loadBalancer);
        client.setRetryHandler(retryHandler);
        Monitors.registerObject((String)("Client_" + this.name), (Object)((Object)client));
        return client;
    }

    @Configuration(proxyBeanMethods=false)
    protected static class OkHttpClientConfiguration {
        private OkHttpClient httpClient;

        protected OkHttpClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={ConnectionPool.class})
        public ConnectionPool httpClientConnectionPool(IClientConfig config, OkHttpClientConnectionPoolFactory connectionPoolFactory) {
            RibbonProperties ribbon = RibbonProperties.from(config);
            int maxTotalConnections = ribbon.maxTotalConnections();
            long timeToLive = ribbon.poolKeepAliveTime();
            TimeUnit ttlUnit = ribbon.getPoolKeepAliveTimeUnits();
            return connectionPoolFactory.create(maxTotalConnections, timeToLive, ttlUnit);
        }

        @Bean
        @ConditionalOnMissingBean(value={OkHttpClient.class})
        public OkHttpClient client(OkHttpClientFactory httpClientFactory, ConnectionPool connectionPool, IClientConfig config) {
            RibbonProperties ribbon = RibbonProperties.from(config);
            this.httpClient = httpClientFactory.createBuilder(false).connectTimeout((long)ribbon.connectTimeout(), TimeUnit.MILLISECONDS).readTimeout((long)ribbon.readTimeout(), TimeUnit.MILLISECONDS).followRedirects(ribbon.isFollowRedirects()).connectionPool(connectionPool).build();
            return this.httpClient;
        }

        @PreDestroy
        public void destroy() {
            if (this.httpClient != null) {
                this.httpClient.dispatcher().executorService().shutdown();
                this.httpClient.connectionPool().evictAll();
            }
        }
    }
}

