/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.turbine;

import com.netflix.turbine.monitor.MonitorConsole;
import com.netflix.turbine.monitor.TurbineDataMonitor;
import com.netflix.turbine.monitor.cluster.AggregateClusterMonitor;
import com.netflix.turbine.monitor.cluster.ClusterMonitor;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.springframework.cloud.netflix.turbine.ClusterInformation;
import org.springframework.http.HttpRequest;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class TurbineInformationService {
    public Collection<ClusterInformation> getClusterInformations(HttpServletRequest request) {
        String hostName = this.getHostName(request);
        return this.getClusterInformations(hostName);
    }

    private Collection<ClusterInformation> getClusterInformations(String hostName) {
        Collection monitors = AggregateClusterMonitor.AggregatorClusterMonitorConsole.getAllMonitors();
        ArrayList<ClusterInformation> clusterInformations = new ArrayList<ClusterInformation>();
        for (TurbineDataMonitor monitor : monitors) {
            ClusterMonitor clusterMonitor = (ClusterMonitor)monitor;
            MonitorConsole instanceConsole = clusterMonitor.getInstanceMonitors();
            for (TurbineDataMonitor single : instanceConsole.getAllMonitors()) {
                String cluster = single.getStatsInstance().getCluster();
                ClusterInformation info = new ClusterInformation(cluster, this.getLink(hostName, cluster));
                clusterInformations.add(info);
            }
        }
        return clusterInformations;
    }

    private String getLink(String hostName, String cluster) {
        return hostName + "/turbine.stream?cluster=" + cluster;
    }

    private String getHostName(HttpServletRequest request) {
        UriComponents components = UriComponentsBuilder.fromHttpRequest((HttpRequest)new ServletServerHttpRequest(request)).build();
        String host = components.getHost();
        int port = components.getPort();
        String scheme = components.getScheme();
        if (port > -1) {
            return String.format("%s://%s:%d", scheme, host, port);
        }
        return String.format("%s://%s", scheme, host);
    }
}

